package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.convert
import dev.toastbits.kjna.runtime.getString
import dev.toastbits.kjna.runtime.memorySegment
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GOptionEntry as _jextract__GOptionEntry
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.GOptionArg

actual class _GOptionEntry constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var long_name: String?
        get() = _jextract__GOptionEntry.long_name(_jextract_value)?.getString()
        set(value) { _jextract__GOptionEntry.long_name(_jextract_value, value?.memorySegment(_mem_scope)) }
    actual var short_name: Char
        get() = _jextract__GOptionEntry.short_name(_jextract_value).convert()
        set(value) { _jextract__GOptionEntry.short_name(_jextract_value, value.convert()) }
    actual var flags: Int
        get() = _jextract__GOptionEntry.flags(_jextract_value)
        set(value) { _jextract__GOptionEntry.flags(_jextract_value, value) }
    actual var arg: GOptionArg
        get() = GOptionArg.entries.first { it.value == _jextract__GOptionEntry.arg(_jextract_value) }
        set(value) { _jextract__GOptionEntry.arg(_jextract_value, value.value) }
    actual var arg_data: KJnaPointer?
        get() = _jextract__GOptionEntry.arg_data(_jextract_value)?.let { KJnaPointer(it).uncheckedCast() }
        set(value) { _jextract__GOptionEntry.arg_data(_jextract_value, value?.pointer) }
    actual var description: String?
        get() = _jextract__GOptionEntry.description(_jextract_value)?.getString()
        set(value) { _jextract__GOptionEntry.description(_jextract_value, value?.memorySegment(_mem_scope)) }
    actual var arg_description: String?
        get() = _jextract__GOptionEntry.arg_description(_jextract_value)?.getString()
        set(value) { _jextract__GOptionEntry.arg_description(_jextract_value, value?.memorySegment(_mem_scope)) }

    override fun toString(): String = 
        "_GOptionEntry(long_name=$long_name, short_name=$short_name, flags=$flags, arg=$arg, arg_data=$arg_data, description=$description, arg_description=$arg_description)"

    companion object: KJnaAllocationCompanion<_GOptionEntry>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GOptionEntry> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GOptionEntry.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GOptionEntry {
            return _GOptionEntry(from.pointer)
        }
        override fun set(value: _GOptionEntry, pointer: KJnaTypedPointer<_GOptionEntry>) {
            pointer.pointer = value._jextract_value
        }
    }
}
