package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GPtrArray as _jextract__GPtrArray
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment

actual class _GPtrArray constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var pdata: KJnaTypedPointer<KJnaPointer?>?
        get() = _jextract__GPtrArray.pdata(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, KJnaAllocationCompanion.ofPrimitive()).uncheckedCast() }
        set(value) { _jextract__GPtrArray.pdata(_jextract_value, value?.pointer) }
    actual var len: UInt
        get() = _jextract__GPtrArray.len(_jextract_value).toUInt()
        set(value) { _jextract__GPtrArray.len(_jextract_value, value.toInt()) }

    override fun toString(): String = 
        "_GPtrArray(pdata=$pdata, len=$len)"

    companion object: KJnaAllocationCompanion<_GPtrArray>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GPtrArray> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GPtrArray.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GPtrArray {
            return _GPtrArray(from.pointer)
        }
        override fun set(value: _GPtrArray, pointer: KJnaTypedPointer<_GPtrArray>) {
            pointer.pointer = value._jextract_value
        }
    }
}
