package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.getString
import dev.toastbits.kjna.runtime.memorySegment
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GSignalQuery as _jextract__GSignalQuery
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.GSignalFlags

actual class _GSignalQuery constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var signal_id: UInt
        get() = _jextract__GSignalQuery.signal_id(_jextract_value).toUInt()
        set(value) { _jextract__GSignalQuery.signal_id(_jextract_value, value.toInt()) }
    actual var signal_name: String?
        get() = _jextract__GSignalQuery.signal_name(_jextract_value)?.getString()
        set(value) { _jextract__GSignalQuery.signal_name(_jextract_value, value?.memorySegment(_mem_scope)) }
    actual var itype: ULong
        get() = _jextract__GSignalQuery.itype(_jextract_value).toULong()
        set(value) { _jextract__GSignalQuery.itype(_jextract_value, value.toLong()) }
    actual var signal_flags: GSignalFlags
        get() = GSignalFlags.entries.first { it.value == _jextract__GSignalQuery.signal_flags(_jextract_value) }
        set(value) { _jextract__GSignalQuery.signal_flags(_jextract_value, value.value) }
    actual var return_type: ULong
        get() = _jextract__GSignalQuery.return_type(_jextract_value).toULong()
        set(value) { _jextract__GSignalQuery.return_type(_jextract_value, value.toLong()) }
    actual var n_params: UInt
        get() = _jextract__GSignalQuery.n_params(_jextract_value).toUInt()
        set(value) { _jextract__GSignalQuery.n_params(_jextract_value, value.toInt()) }
    actual var param_types: KJnaTypedPointer<ULong>?
        get() = _jextract__GSignalQuery.param_types(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, KJnaAllocationCompanion.ofPrimitive()).uncheckedCast() }
        set(value) { _jextract__GSignalQuery.param_types(_jextract_value, value?.pointer) }

    override fun toString(): String = 
        "_GSignalQuery(signal_id=$signal_id, signal_name=$signal_name, itype=$itype, signal_flags=$signal_flags, return_type=$return_type, n_params=$n_params, param_types=$param_types)"

    companion object: KJnaAllocationCompanion<_GSignalQuery>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GSignalQuery> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GSignalQuery.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GSignalQuery {
            return _GSignalQuery(from.pointer)
        }
        override fun set(value: _GSignalQuery, pointer: KJnaTypedPointer<_GSignalQuery>) {
            pointer.pointer = value._jextract_value
        }
    }
}
