package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.getString
import dev.toastbits.kjna.runtime.memorySegment
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GSource as _jextract__GSource
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.struct._GMainContext
import kjna.struct._GSList
import kjna.struct._GSource
import kjna.struct._GSourceCallbackFuncs
import kjna.struct._GSourceFuncs
import kjna.struct._GSourcePrivate

actual class _GSource constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var callback_data: KJnaPointer?
        get() = _jextract__GSource.callback_data(_jextract_value)?.let { KJnaPointer(it).uncheckedCast() }
        set(value) { _jextract__GSource.callback_data(_jextract_value, value?.pointer) }
    actual var callback_funcs: KJnaTypedPointer<_GSourceCallbackFuncs>?
        get() = _jextract__GSource.callback_funcs(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GSourceCallbackFuncs.Companion).uncheckedCast() }
        set(value) { _jextract__GSource.callback_funcs(_jextract_value, value?.pointer) }
    actual var source_funcs: KJnaTypedPointer<_GSourceFuncs>?
        get() = _jextract__GSource.source_funcs(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GSourceFuncs.Companion).uncheckedCast() }
        set(value) { _jextract__GSource.source_funcs(_jextract_value, value?.pointer) }
    actual var ref_count: UInt
        get() = _jextract__GSource.ref_count(_jextract_value).toUInt()
        set(value) { _jextract__GSource.ref_count(_jextract_value, value.toInt()) }
    actual var context: KJnaTypedPointer<_GMainContext>?
        get() = _jextract__GSource.context(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GMainContext.Companion).uncheckedCast() }
        set(value) { _jextract__GSource.context(_jextract_value, value?.pointer) }
    actual var priority: Int
        get() = _jextract__GSource.priority(_jextract_value)
        set(value) { _jextract__GSource.priority(_jextract_value, value) }
    actual var flags: UInt
        get() = _jextract__GSource.flags(_jextract_value).toUInt()
        set(value) { _jextract__GSource.flags(_jextract_value, value.toInt()) }
    actual var source_id: UInt
        get() = _jextract__GSource.source_id(_jextract_value).toUInt()
        set(value) { _jextract__GSource.source_id(_jextract_value, value.toInt()) }
    actual var poll_fds: KJnaTypedPointer<_GSList>?
        get() = _jextract__GSource.poll_fds(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GSList.Companion).uncheckedCast() }
        set(value) { _jextract__GSource.poll_fds(_jextract_value, value?.pointer) }
    actual var prev: KJnaTypedPointer<_GSource>?
        get() = _jextract__GSource.prev(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GSource.Companion).uncheckedCast() }
        set(value) { _jextract__GSource.prev(_jextract_value, value?.pointer) }
    actual var next: KJnaTypedPointer<_GSource>?
        get() = _jextract__GSource.next(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GSource.Companion).uncheckedCast() }
        set(value) { _jextract__GSource.next(_jextract_value, value?.pointer) }
    actual var name: String?
        get() = _jextract__GSource.name(_jextract_value)?.getString()
        set(value) { _jextract__GSource.name(_jextract_value, value?.memorySegment(_mem_scope)) }
    actual var priv: KJnaTypedPointer<_GSourcePrivate>?
        get() = _jextract__GSource.priv(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GSourcePrivate.Companion).uncheckedCast() }
        set(value) { _jextract__GSource.priv(_jextract_value, value?.pointer) }

    override fun toString(): String = 
        "_GSource(callback_data=$callback_data, callback_funcs=$callback_funcs, source_funcs=$source_funcs, ref_count=$ref_count, context=$context, priority=$priority, flags=$flags, source_id=$source_id, poll_fds=$poll_fds, prev=$prev, next=$next, name=$name, priv=$priv)"

    companion object: KJnaAllocationCompanion<_GSource>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GSource> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GSource.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GSource {
            return _GSource(from.pointer)
        }
        override fun set(value: _GSource, pointer: KJnaTypedPointer<_GSource>) {
            pointer.pointer = value._jextract_value
        }
    }
}
