package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.convert
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GdkEventButton as _jextract__GdkEventButton
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.GdkEventType
import kjna.struct._GdkDevice
import kjna.struct._GdkWindow

actual class _GdkEventButton constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var type: GdkEventType
        get() = GdkEventType.entries.first { it.value == _jextract__GdkEventButton.type(_jextract_value) }
        set(value) { _jextract__GdkEventButton.type(_jextract_value, value.value) }
    actual var window: KJnaTypedPointer<_GdkWindow>?
        get() = _jextract__GdkEventButton.window(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkWindow.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventButton.window(_jextract_value, value?.pointer) }
    actual var send_event: Char
        get() = _jextract__GdkEventButton.send_event(_jextract_value).convert()
        set(value) { _jextract__GdkEventButton.send_event(_jextract_value, value.convert()) }
    actual var time: UInt
        get() = _jextract__GdkEventButton.time(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventButton.time(_jextract_value, value.toInt()) }
    actual var x: Double
        get() = _jextract__GdkEventButton.x(_jextract_value)
        set(value) { _jextract__GdkEventButton.x(_jextract_value, value) }
    actual var y: Double
        get() = _jextract__GdkEventButton.y(_jextract_value)
        set(value) { _jextract__GdkEventButton.y(_jextract_value, value) }
    actual var axes: KJnaTypedPointer<Double>?
        get() = _jextract__GdkEventButton.axes(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, KJnaAllocationCompanion.ofPrimitive()).uncheckedCast() }
        set(value) { _jextract__GdkEventButton.axes(_jextract_value, value?.pointer) }
    actual var state: UInt
        get() = _jextract__GdkEventButton.state(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventButton.state(_jextract_value, value.toInt()) }
    actual var button: UInt
        get() = _jextract__GdkEventButton.button(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventButton.button(_jextract_value, value.toInt()) }
    actual var device: KJnaTypedPointer<_GdkDevice>?
        get() = _jextract__GdkEventButton.device(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkDevice.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventButton.device(_jextract_value, value?.pointer) }
    actual var x_root: Double
        get() = _jextract__GdkEventButton.x_root(_jextract_value)
        set(value) { _jextract__GdkEventButton.x_root(_jextract_value, value) }

    override fun toString(): String = 
        "_GdkEventButton(type=$type, window=$window, send_event=$send_event, time=$time, x=$x, y=$y, axes=$axes, state=$state, button=$button, device=$device, x_root=$x_root)"

    companion object: KJnaAllocationCompanion<_GdkEventButton>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GdkEventButton> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GdkEventButton.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GdkEventButton {
            return _GdkEventButton(from.pointer)
        }
        override fun set(value: _GdkEventButton, pointer: KJnaTypedPointer<_GdkEventButton>) {
            pointer.pointer = value._jextract_value
        }
    }
}
