package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.convert
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GdkEventConfigure as _jextract__GdkEventConfigure
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.GdkEventType
import kjna.struct._GdkWindow

actual class _GdkEventConfigure constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var type: GdkEventType
        get() = GdkEventType.entries.first { it.value == _jextract__GdkEventConfigure.type(_jextract_value) }
        set(value) { _jextract__GdkEventConfigure.type(_jextract_value, value.value) }
    actual var window: KJnaTypedPointer<_GdkWindow>?
        get() = _jextract__GdkEventConfigure.window(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkWindow.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventConfigure.window(_jextract_value, value?.pointer) }
    actual var send_event: Char
        get() = _jextract__GdkEventConfigure.send_event(_jextract_value).convert()
        set(value) { _jextract__GdkEventConfigure.send_event(_jextract_value, value.convert()) }
    actual var x: Int
        get() = _jextract__GdkEventConfigure.x(_jextract_value)
        set(value) { _jextract__GdkEventConfigure.x(_jextract_value, value) }
    actual var width: Int
        get() = _jextract__GdkEventConfigure.width(_jextract_value)
        set(value) { _jextract__GdkEventConfigure.width(_jextract_value, value) }
    actual var height: Int
        get() = _jextract__GdkEventConfigure.height(_jextract_value)
        set(value) { _jextract__GdkEventConfigure.height(_jextract_value, value) }

    override fun toString(): String = 
        "_GdkEventConfigure(type=$type, window=$window, send_event=$send_event, x=$x, width=$width, height=$height)"

    companion object: KJnaAllocationCompanion<_GdkEventConfigure>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GdkEventConfigure> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GdkEventConfigure.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GdkEventConfigure {
            return _GdkEventConfigure(from.pointer)
        }
        override fun set(value: _GdkEventConfigure, pointer: KJnaTypedPointer<_GdkEventConfigure>) {
            pointer.pointer = value._jextract_value
        }
    }
}
