package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.convert
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GdkEventCrossing as _jextract__GdkEventCrossing
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.GdkCrossingMode
import kjna.enum.GdkEventType
import kjna.enum.GdkNotifyType
import kjna.struct._GdkWindow

actual class _GdkEventCrossing constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var type: GdkEventType
        get() = GdkEventType.entries.first { it.value == _jextract__GdkEventCrossing.type(_jextract_value) }
        set(value) { _jextract__GdkEventCrossing.type(_jextract_value, value.value) }
    actual var window: KJnaTypedPointer<_GdkWindow>?
        get() = _jextract__GdkEventCrossing.window(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkWindow.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventCrossing.window(_jextract_value, value?.pointer) }
    actual var send_event: Char
        get() = _jextract__GdkEventCrossing.send_event(_jextract_value).convert()
        set(value) { _jextract__GdkEventCrossing.send_event(_jextract_value, value.convert()) }
    actual var subwindow: KJnaTypedPointer<_GdkWindow>?
        get() = _jextract__GdkEventCrossing.subwindow(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkWindow.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventCrossing.subwindow(_jextract_value, value?.pointer) }
    actual var time: UInt
        get() = _jextract__GdkEventCrossing.time(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventCrossing.time(_jextract_value, value.toInt()) }
    actual var x: Double
        get() = _jextract__GdkEventCrossing.x(_jextract_value)
        set(value) { _jextract__GdkEventCrossing.x(_jextract_value, value) }
    actual var y: Double
        get() = _jextract__GdkEventCrossing.y(_jextract_value)
        set(value) { _jextract__GdkEventCrossing.y(_jextract_value, value) }
    actual var x_root: Double
        get() = _jextract__GdkEventCrossing.x_root(_jextract_value)
        set(value) { _jextract__GdkEventCrossing.x_root(_jextract_value, value) }
    actual var y_root: Double
        get() = _jextract__GdkEventCrossing.y_root(_jextract_value)
        set(value) { _jextract__GdkEventCrossing.y_root(_jextract_value, value) }
    actual var mode: GdkCrossingMode
        get() = GdkCrossingMode.entries.first { it.value == _jextract__GdkEventCrossing.mode(_jextract_value) }
        set(value) { _jextract__GdkEventCrossing.mode(_jextract_value, value.value) }
    actual var detail: GdkNotifyType
        get() = GdkNotifyType.entries.first { it.value == _jextract__GdkEventCrossing.detail(_jextract_value) }
        set(value) { _jextract__GdkEventCrossing.detail(_jextract_value, value.value) }
    actual var focus: Int
        get() = _jextract__GdkEventCrossing.focus(_jextract_value)
        set(value) { _jextract__GdkEventCrossing.focus(_jextract_value, value) }
    actual var state: UInt
        get() = _jextract__GdkEventCrossing.state(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventCrossing.state(_jextract_value, value.toInt()) }

    override fun toString(): String = 
        "_GdkEventCrossing(type=$type, window=$window, send_event=$send_event, subwindow=$subwindow, time=$time, x=$x, y=$y, x_root=$x_root, y_root=$y_root, mode=$mode, detail=$detail, focus=$focus, state=$state)"

    companion object: KJnaAllocationCompanion<_GdkEventCrossing>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GdkEventCrossing> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GdkEventCrossing.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GdkEventCrossing {
            return _GdkEventCrossing(from.pointer)
        }
        override fun set(value: _GdkEventCrossing, pointer: KJnaTypedPointer<_GdkEventCrossing>) {
            pointer.pointer = value._jextract_value
        }
    }
}
