package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.convert
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GdkEventDND as _jextract__GdkEventDND
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.GdkEventType
import kjna.struct._GdkDragContext
import kjna.struct._GdkWindow

actual class _GdkEventDND constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var type: GdkEventType
        get() = GdkEventType.entries.first { it.value == _jextract__GdkEventDND.type(_jextract_value) }
        set(value) { _jextract__GdkEventDND.type(_jextract_value, value.value) }
    actual var window: KJnaTypedPointer<_GdkWindow>?
        get() = _jextract__GdkEventDND.window(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkWindow.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventDND.window(_jextract_value, value?.pointer) }
    actual var send_event: Char
        get() = _jextract__GdkEventDND.send_event(_jextract_value).convert()
        set(value) { _jextract__GdkEventDND.send_event(_jextract_value, value.convert()) }
    actual var context: KJnaTypedPointer<_GdkDragContext>?
        get() = _jextract__GdkEventDND.context(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkDragContext.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventDND.context(_jextract_value, value?.pointer) }
    actual var time: UInt
        get() = _jextract__GdkEventDND.time(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventDND.time(_jextract_value, value.toInt()) }
    actual var x_root: Short
        get() = _jextract__GdkEventDND.x_root(_jextract_value)
        set(value) { _jextract__GdkEventDND.x_root(_jextract_value, value.toShort()) }

    override fun toString(): String = 
        "_GdkEventDND(type=$type, window=$window, send_event=$send_event, context=$context, time=$time, x_root=$x_root)"

    companion object: KJnaAllocationCompanion<_GdkEventDND>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GdkEventDND> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GdkEventDND.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GdkEventDND {
            return _GdkEventDND(from.pointer)
        }
        override fun set(value: _GdkEventDND, pointer: KJnaTypedPointer<_GdkEventDND>) {
            pointer.pointer = value._jextract_value
        }
    }
}
