package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.convert
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GdkEventExpose as _jextract__GdkEventExpose
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.GdkEventType
import kjna.struct._GdkWindow
import kjna.struct._cairo_rectangle_int
import kjna.struct._cairo_region

actual class _GdkEventExpose constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var type: GdkEventType
        get() = GdkEventType.entries.first { it.value == _jextract__GdkEventExpose.type(_jextract_value) }
        set(value) { _jextract__GdkEventExpose.type(_jextract_value, value.value) }
    actual var window: KJnaTypedPointer<_GdkWindow>?
        get() = _jextract__GdkEventExpose.window(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkWindow.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventExpose.window(_jextract_value, value?.pointer) }
    actual var send_event: Char
        get() = _jextract__GdkEventExpose.send_event(_jextract_value).convert()
        set(value) { _jextract__GdkEventExpose.send_event(_jextract_value, value.convert()) }
    actual val area: _cairo_rectangle_int
        get() = _cairo_rectangle_int(_jextract__GdkEventExpose.area(_jextract_value))
    actual var region: KJnaTypedPointer<_cairo_region>?
        get() = _jextract__GdkEventExpose.region(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _cairo_region.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventExpose.region(_jextract_value, value?.pointer) }
    actual var count: Int
        get() = _jextract__GdkEventExpose.count(_jextract_value)
        set(value) { _jextract__GdkEventExpose.count(_jextract_value, value) }

    override fun toString(): String = 
        "_GdkEventExpose(type=$type, window=$window, send_event=$send_event, area=$area, region=$region, count=$count)"

    companion object: KJnaAllocationCompanion<_GdkEventExpose>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GdkEventExpose> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GdkEventExpose.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GdkEventExpose {
            return _GdkEventExpose(from.pointer)
        }
        override fun set(value: _GdkEventExpose, pointer: KJnaTypedPointer<_GdkEventExpose>) {
            pointer.pointer = value._jextract_value
        }
    }
}
