package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.convert
import dev.toastbits.kjna.runtime.getString
import dev.toastbits.kjna.runtime.memorySegment
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GdkEventKey as _jextract__GdkEventKey
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.GdkEventType
import kjna.struct._GdkWindow

actual class _GdkEventKey constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var type: GdkEventType
        get() = GdkEventType.entries.first { it.value == _jextract__GdkEventKey.type(_jextract_value) }
        set(value) { _jextract__GdkEventKey.type(_jextract_value, value.value) }
    actual var window: KJnaTypedPointer<_GdkWindow>?
        get() = _jextract__GdkEventKey.window(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkWindow.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventKey.window(_jextract_value, value?.pointer) }
    actual var send_event: Char
        get() = _jextract__GdkEventKey.send_event(_jextract_value).convert()
        set(value) { _jextract__GdkEventKey.send_event(_jextract_value, value.convert()) }
    actual var time: UInt
        get() = _jextract__GdkEventKey.time(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventKey.time(_jextract_value, value.toInt()) }
    actual var state: UInt
        get() = _jextract__GdkEventKey.state(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventKey.state(_jextract_value, value.toInt()) }
    actual var keyval: UInt
        get() = _jextract__GdkEventKey.keyval(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventKey.keyval(_jextract_value, value.toInt()) }
    actual var length: Int
        get() = _jextract__GdkEventKey.length(_jextract_value)
        set(value) { _jextract__GdkEventKey.length(_jextract_value, value) }
    actual var string: String?
        get() = _jextract__GdkEventKey.string(_jextract_value)?.getString()
        set(value) { _jextract__GdkEventKey.string(_jextract_value, value?.memorySegment(_mem_scope)) }
    actual var hardware_keycode: UShort
        get() = _jextract__GdkEventKey.hardware_keycode(_jextract_value).toUShort()
        set(value) { _jextract__GdkEventKey.hardware_keycode(_jextract_value, value.toShort()) }
    actual var group: Char
        get() = _jextract__GdkEventKey.group(_jextract_value).convert()
        set(value) { _jextract__GdkEventKey.group(_jextract_value, value.convert()) }

    override fun toString(): String = 
        "_GdkEventKey(type=$type, window=$window, send_event=$send_event, time=$time, state=$state, keyval=$keyval, length=$length, string=$string, hardware_keycode=$hardware_keycode, group=$group)"

    companion object: KJnaAllocationCompanion<_GdkEventKey>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GdkEventKey> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GdkEventKey.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GdkEventKey {
            return _GdkEventKey(from.pointer)
        }
        override fun set(value: _GdkEventKey, pointer: KJnaTypedPointer<_GdkEventKey>) {
            pointer.pointer = value._jextract_value
        }
    }
}
