package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.convert
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GdkEventOwnerChange as _jextract__GdkEventOwnerChange
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.GdkEventType
import kjna.enum.GdkOwnerChange
import kjna.struct._GdkAtom
import kjna.struct._GdkWindow

actual class _GdkEventOwnerChange constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var type: GdkEventType
        get() = GdkEventType.entries.first { it.value == _jextract__GdkEventOwnerChange.type(_jextract_value) }
        set(value) { _jextract__GdkEventOwnerChange.type(_jextract_value, value.value) }
    actual var window: KJnaTypedPointer<_GdkWindow>?
        get() = _jextract__GdkEventOwnerChange.window(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkWindow.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventOwnerChange.window(_jextract_value, value?.pointer) }
    actual var send_event: Char
        get() = _jextract__GdkEventOwnerChange.send_event(_jextract_value).convert()
        set(value) { _jextract__GdkEventOwnerChange.send_event(_jextract_value, value.convert()) }
    actual var owner: KJnaTypedPointer<_GdkWindow>?
        get() = _jextract__GdkEventOwnerChange.owner(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkWindow.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventOwnerChange.owner(_jextract_value, value?.pointer) }
    actual var reason: GdkOwnerChange
        get() = GdkOwnerChange.entries.first { it.value == _jextract__GdkEventOwnerChange.reason(_jextract_value) }
        set(value) { _jextract__GdkEventOwnerChange.reason(_jextract_value, value.value) }
    actual var selection: KJnaTypedPointer<_GdkAtom>?
        get() = _jextract__GdkEventOwnerChange.selection(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkAtom.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventOwnerChange.selection(_jextract_value, value?.pointer) }
    actual var time: UInt
        get() = _jextract__GdkEventOwnerChange.time(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventOwnerChange.time(_jextract_value, value.toInt()) }
    actual var selection_time: UInt
        get() = _jextract__GdkEventOwnerChange.selection_time(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventOwnerChange.selection_time(_jextract_value, value.toInt()) }

    override fun toString(): String = 
        "_GdkEventOwnerChange(type=$type, window=$window, send_event=$send_event, owner=$owner, reason=$reason, selection=$selection, time=$time, selection_time=$selection_time)"

    companion object: KJnaAllocationCompanion<_GdkEventOwnerChange>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GdkEventOwnerChange> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GdkEventOwnerChange.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GdkEventOwnerChange {
            return _GdkEventOwnerChange(from.pointer)
        }
        override fun set(value: _GdkEventOwnerChange, pointer: KJnaTypedPointer<_GdkEventOwnerChange>) {
            pointer.pointer = value._jextract_value
        }
    }
}
