package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.convert
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GdkEventProperty as _jextract__GdkEventProperty
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.GdkEventType
import kjna.struct._GdkAtom
import kjna.struct._GdkWindow

actual class _GdkEventProperty constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var type: GdkEventType
        get() = GdkEventType.entries.first { it.value == _jextract__GdkEventProperty.type(_jextract_value) }
        set(value) { _jextract__GdkEventProperty.type(_jextract_value, value.value) }
    actual var window: KJnaTypedPointer<_GdkWindow>?
        get() = _jextract__GdkEventProperty.window(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkWindow.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventProperty.window(_jextract_value, value?.pointer) }
    actual var send_event: Char
        get() = _jextract__GdkEventProperty.send_event(_jextract_value).convert()
        set(value) { _jextract__GdkEventProperty.send_event(_jextract_value, value.convert()) }
    actual var atom: KJnaTypedPointer<_GdkAtom>?
        get() = _jextract__GdkEventProperty.atom(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkAtom.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventProperty.atom(_jextract_value, value?.pointer) }
    actual var time: UInt
        get() = _jextract__GdkEventProperty.time(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventProperty.time(_jextract_value, value.toInt()) }
    actual var state: UInt
        get() = _jextract__GdkEventProperty.state(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventProperty.state(_jextract_value, value.toInt()) }

    override fun toString(): String = 
        "_GdkEventProperty(type=$type, window=$window, send_event=$send_event, atom=$atom, time=$time, state=$state)"

    companion object: KJnaAllocationCompanion<_GdkEventProperty>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GdkEventProperty> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GdkEventProperty.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GdkEventProperty {
            return _GdkEventProperty(from.pointer)
        }
        override fun set(value: _GdkEventProperty, pointer: KJnaTypedPointer<_GdkEventProperty>) {
            pointer.pointer = value._jextract_value
        }
    }
}
