package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.convert
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GdkEventProximity as _jextract__GdkEventProximity
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.GdkEventType
import kjna.struct._GdkDevice
import kjna.struct._GdkWindow

actual class _GdkEventProximity constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var type: GdkEventType
        get() = GdkEventType.entries.first { it.value == _jextract__GdkEventProximity.type(_jextract_value) }
        set(value) { _jextract__GdkEventProximity.type(_jextract_value, value.value) }
    actual var window: KJnaTypedPointer<_GdkWindow>?
        get() = _jextract__GdkEventProximity.window(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkWindow.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventProximity.window(_jextract_value, value?.pointer) }
    actual var send_event: Char
        get() = _jextract__GdkEventProximity.send_event(_jextract_value).convert()
        set(value) { _jextract__GdkEventProximity.send_event(_jextract_value, value.convert()) }
    actual var time: UInt
        get() = _jextract__GdkEventProximity.time(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventProximity.time(_jextract_value, value.toInt()) }
    actual var device: KJnaTypedPointer<_GdkDevice>?
        get() = _jextract__GdkEventProximity.device(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkDevice.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventProximity.device(_jextract_value, value?.pointer) }

    override fun toString(): String = 
        "_GdkEventProximity(type=$type, window=$window, send_event=$send_event, time=$time, device=$device)"

    companion object: KJnaAllocationCompanion<_GdkEventProximity>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GdkEventProximity> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GdkEventProximity.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GdkEventProximity {
            return _GdkEventProximity(from.pointer)
        }
        override fun set(value: _GdkEventProximity, pointer: KJnaTypedPointer<_GdkEventProximity>) {
            pointer.pointer = value._jextract_value
        }
    }
}
