package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.convert
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GdkEventScroll as _jextract__GdkEventScroll
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.GdkEventType
import kjna.enum.GdkScrollDirection
import kjna.struct._GdkDevice
import kjna.struct._GdkWindow

actual class _GdkEventScroll constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var type: GdkEventType
        get() = GdkEventType.entries.first { it.value == _jextract__GdkEventScroll.type(_jextract_value) }
        set(value) { _jextract__GdkEventScroll.type(_jextract_value, value.value) }
    actual var window: KJnaTypedPointer<_GdkWindow>?
        get() = _jextract__GdkEventScroll.window(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkWindow.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventScroll.window(_jextract_value, value?.pointer) }
    actual var send_event: Char
        get() = _jextract__GdkEventScroll.send_event(_jextract_value).convert()
        set(value) { _jextract__GdkEventScroll.send_event(_jextract_value, value.convert()) }
    actual var time: UInt
        get() = _jextract__GdkEventScroll.time(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventScroll.time(_jextract_value, value.toInt()) }
    actual var x: Double
        get() = _jextract__GdkEventScroll.x(_jextract_value)
        set(value) { _jextract__GdkEventScroll.x(_jextract_value, value) }
    actual var y: Double
        get() = _jextract__GdkEventScroll.y(_jextract_value)
        set(value) { _jextract__GdkEventScroll.y(_jextract_value, value) }
    actual var state: UInt
        get() = _jextract__GdkEventScroll.state(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventScroll.state(_jextract_value, value.toInt()) }
    actual var direction: GdkScrollDirection
        get() = GdkScrollDirection.entries.first { it.value == _jextract__GdkEventScroll.direction(_jextract_value) }
        set(value) { _jextract__GdkEventScroll.direction(_jextract_value, value.value) }
    actual var device: KJnaTypedPointer<_GdkDevice>?
        get() = _jextract__GdkEventScroll.device(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkDevice.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventScroll.device(_jextract_value, value?.pointer) }
    actual var x_root: Double
        get() = _jextract__GdkEventScroll.x_root(_jextract_value)
        set(value) { _jextract__GdkEventScroll.x_root(_jextract_value, value) }
    actual var delta_x: Double
        get() = _jextract__GdkEventScroll.delta_x(_jextract_value)
        set(value) { _jextract__GdkEventScroll.delta_x(_jextract_value, value) }
    actual var delta_y: Double
        get() = _jextract__GdkEventScroll.delta_y(_jextract_value)
        set(value) { _jextract__GdkEventScroll.delta_y(_jextract_value, value) }

    override fun toString(): String = 
        "_GdkEventScroll(type=$type, window=$window, send_event=$send_event, time=$time, x=$x, y=$y, state=$state, direction=$direction, device=$device, x_root=$x_root, delta_x=$delta_x, delta_y=$delta_y)"

    companion object: KJnaAllocationCompanion<_GdkEventScroll>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GdkEventScroll> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GdkEventScroll.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GdkEventScroll {
            return _GdkEventScroll(from.pointer)
        }
        override fun set(value: _GdkEventScroll, pointer: KJnaTypedPointer<_GdkEventScroll>) {
            pointer.pointer = value._jextract_value
        }
    }
}
