package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.convert
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GdkEventSelection as _jextract__GdkEventSelection
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.GdkEventType
import kjna.struct._GdkAtom
import kjna.struct._GdkWindow

actual class _GdkEventSelection constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var type: GdkEventType
        get() = GdkEventType.entries.first { it.value == _jextract__GdkEventSelection.type(_jextract_value) }
        set(value) { _jextract__GdkEventSelection.type(_jextract_value, value.value) }
    actual var window: KJnaTypedPointer<_GdkWindow>?
        get() = _jextract__GdkEventSelection.window(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkWindow.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventSelection.window(_jextract_value, value?.pointer) }
    actual var send_event: Char
        get() = _jextract__GdkEventSelection.send_event(_jextract_value).convert()
        set(value) { _jextract__GdkEventSelection.send_event(_jextract_value, value.convert()) }
    actual var selection: KJnaTypedPointer<_GdkAtom>?
        get() = _jextract__GdkEventSelection.selection(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkAtom.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventSelection.selection(_jextract_value, value?.pointer) }
    actual var target: KJnaTypedPointer<_GdkAtom>?
        get() = _jextract__GdkEventSelection.target(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkAtom.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventSelection.target(_jextract_value, value?.pointer) }
    actual var property: KJnaTypedPointer<_GdkAtom>?
        get() = _jextract__GdkEventSelection.property(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkAtom.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventSelection.property(_jextract_value, value?.pointer) }
    actual var time: UInt
        get() = _jextract__GdkEventSelection.time(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventSelection.time(_jextract_value, value.toInt()) }
    actual var requestor: KJnaTypedPointer<_GdkWindow>?
        get() = _jextract__GdkEventSelection.requestor(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkWindow.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventSelection.requestor(_jextract_value, value?.pointer) }

    override fun toString(): String = 
        "_GdkEventSelection(type=$type, window=$window, send_event=$send_event, selection=$selection, target=$target, property=$property, time=$time, requestor=$requestor)"

    companion object: KJnaAllocationCompanion<_GdkEventSelection>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GdkEventSelection> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GdkEventSelection.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GdkEventSelection {
            return _GdkEventSelection(from.pointer)
        }
        override fun set(value: _GdkEventSelection, pointer: KJnaTypedPointer<_GdkEventSelection>) {
            pointer.pointer = value._jextract_value
        }
    }
}
