package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.convert
import dev.toastbits.kjna.runtime.getString
import dev.toastbits.kjna.runtime.memorySegment
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GdkEventSetting as _jextract__GdkEventSetting
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.GdkEventType
import kjna.enum.GdkSettingAction
import kjna.struct._GdkWindow

actual class _GdkEventSetting constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var type: GdkEventType
        get() = GdkEventType.entries.first { it.value == _jextract__GdkEventSetting.type(_jextract_value) }
        set(value) { _jextract__GdkEventSetting.type(_jextract_value, value.value) }
    actual var window: KJnaTypedPointer<_GdkWindow>?
        get() = _jextract__GdkEventSetting.window(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkWindow.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventSetting.window(_jextract_value, value?.pointer) }
    actual var send_event: Char
        get() = _jextract__GdkEventSetting.send_event(_jextract_value).convert()
        set(value) { _jextract__GdkEventSetting.send_event(_jextract_value, value.convert()) }
    actual var action: GdkSettingAction
        get() = GdkSettingAction.entries.first { it.value == _jextract__GdkEventSetting.action(_jextract_value) }
        set(value) { _jextract__GdkEventSetting.action(_jextract_value, value.value) }
    actual var name: String?
        get() = _jextract__GdkEventSetting.name(_jextract_value)?.getString()
        set(value) { _jextract__GdkEventSetting.name(_jextract_value, value?.memorySegment(_mem_scope)) }

    override fun toString(): String = 
        "_GdkEventSetting(type=$type, window=$window, send_event=$send_event, action=$action, name=$name)"

    companion object: KJnaAllocationCompanion<_GdkEventSetting>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GdkEventSetting> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GdkEventSetting.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GdkEventSetting {
            return _GdkEventSetting(from.pointer)
        }
        override fun set(value: _GdkEventSetting, pointer: KJnaTypedPointer<_GdkEventSetting>) {
            pointer.pointer = value._jextract_value
        }
    }
}
