package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.convert
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GdkEventTouch as _jextract__GdkEventTouch
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.GdkEventType
import kjna.struct._GdkDevice
import kjna.struct._GdkEventSequence
import kjna.struct._GdkWindow

actual class _GdkEventTouch constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var type: GdkEventType
        get() = GdkEventType.entries.first { it.value == _jextract__GdkEventTouch.type(_jextract_value) }
        set(value) { _jextract__GdkEventTouch.type(_jextract_value, value.value) }
    actual var window: KJnaTypedPointer<_GdkWindow>?
        get() = _jextract__GdkEventTouch.window(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkWindow.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventTouch.window(_jextract_value, value?.pointer) }
    actual var send_event: Char
        get() = _jextract__GdkEventTouch.send_event(_jextract_value).convert()
        set(value) { _jextract__GdkEventTouch.send_event(_jextract_value, value.convert()) }
    actual var time: UInt
        get() = _jextract__GdkEventTouch.time(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventTouch.time(_jextract_value, value.toInt()) }
    actual var x: Double
        get() = _jextract__GdkEventTouch.x(_jextract_value)
        set(value) { _jextract__GdkEventTouch.x(_jextract_value, value) }
    actual var y: Double
        get() = _jextract__GdkEventTouch.y(_jextract_value)
        set(value) { _jextract__GdkEventTouch.y(_jextract_value, value) }
    actual var axes: KJnaTypedPointer<Double>?
        get() = _jextract__GdkEventTouch.axes(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, KJnaAllocationCompanion.ofPrimitive()).uncheckedCast() }
        set(value) { _jextract__GdkEventTouch.axes(_jextract_value, value?.pointer) }
    actual var state: UInt
        get() = _jextract__GdkEventTouch.state(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventTouch.state(_jextract_value, value.toInt()) }
    actual var sequence: KJnaTypedPointer<_GdkEventSequence>?
        get() = _jextract__GdkEventTouch.sequence(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkEventSequence.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventTouch.sequence(_jextract_value, value?.pointer) }
    actual var emulating_pointer: Int
        get() = _jextract__GdkEventTouch.emulating_pointer(_jextract_value)
        set(value) { _jextract__GdkEventTouch.emulating_pointer(_jextract_value, value) }
    actual var device: KJnaTypedPointer<_GdkDevice>?
        get() = _jextract__GdkEventTouch.device(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkDevice.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventTouch.device(_jextract_value, value?.pointer) }
    actual var x_root: Double
        get() = _jextract__GdkEventTouch.x_root(_jextract_value)
        set(value) { _jextract__GdkEventTouch.x_root(_jextract_value, value) }

    override fun toString(): String = 
        "_GdkEventTouch(type=$type, window=$window, send_event=$send_event, time=$time, x=$x, y=$y, axes=$axes, state=$state, sequence=$sequence, emulating_pointer=$emulating_pointer, device=$device, x_root=$x_root)"

    companion object: KJnaAllocationCompanion<_GdkEventTouch>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GdkEventTouch> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GdkEventTouch.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GdkEventTouch {
            return _GdkEventTouch(from.pointer)
        }
        override fun set(value: _GdkEventTouch, pointer: KJnaTypedPointer<_GdkEventTouch>) {
            pointer.pointer = value._jextract_value
        }
    }
}
