package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.convert
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GdkEventTouchpadPinch as _jextract__GdkEventTouchpadPinch
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.GdkEventType
import kjna.struct._GdkWindow

actual class _GdkEventTouchpadPinch constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var type: GdkEventType
        get() = GdkEventType.entries.first { it.value == _jextract__GdkEventTouchpadPinch.type(_jextract_value) }
        set(value) { _jextract__GdkEventTouchpadPinch.type(_jextract_value, value.value) }
    actual var window: KJnaTypedPointer<_GdkWindow>?
        get() = _jextract__GdkEventTouchpadPinch.window(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkWindow.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventTouchpadPinch.window(_jextract_value, value?.pointer) }
    actual var send_event: Char
        get() = _jextract__GdkEventTouchpadPinch.send_event(_jextract_value).convert()
        set(value) { _jextract__GdkEventTouchpadPinch.send_event(_jextract_value, value.convert()) }
    actual var phase: Char
        get() = _jextract__GdkEventTouchpadPinch.phase(_jextract_value).convert()
        set(value) { _jextract__GdkEventTouchpadPinch.phase(_jextract_value, value.convert()) }
    actual var n_fingers: Char
        get() = _jextract__GdkEventTouchpadPinch.n_fingers(_jextract_value).convert()
        set(value) { _jextract__GdkEventTouchpadPinch.n_fingers(_jextract_value, value.convert()) }
    actual var time: UInt
        get() = _jextract__GdkEventTouchpadPinch.time(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventTouchpadPinch.time(_jextract_value, value.toInt()) }
    actual var x: Double
        get() = _jextract__GdkEventTouchpadPinch.x(_jextract_value)
        set(value) { _jextract__GdkEventTouchpadPinch.x(_jextract_value, value) }
    actual var y: Double
        get() = _jextract__GdkEventTouchpadPinch.y(_jextract_value)
        set(value) { _jextract__GdkEventTouchpadPinch.y(_jextract_value, value) }
    actual var dx: Double
        get() = _jextract__GdkEventTouchpadPinch.dx(_jextract_value)
        set(value) { _jextract__GdkEventTouchpadPinch.dx(_jextract_value, value) }
    actual var dy: Double
        get() = _jextract__GdkEventTouchpadPinch.dy(_jextract_value)
        set(value) { _jextract__GdkEventTouchpadPinch.dy(_jextract_value, value) }
    actual var angle_delta: Double
        get() = _jextract__GdkEventTouchpadPinch.angle_delta(_jextract_value)
        set(value) { _jextract__GdkEventTouchpadPinch.angle_delta(_jextract_value, value) }
    actual var scale: Double
        get() = _jextract__GdkEventTouchpadPinch.scale(_jextract_value)
        set(value) { _jextract__GdkEventTouchpadPinch.scale(_jextract_value, value) }
    actual var x_root: Double
        get() = _jextract__GdkEventTouchpadPinch.x_root(_jextract_value)
        set(value) { _jextract__GdkEventTouchpadPinch.x_root(_jextract_value, value) }
    actual var state: UInt
        get() = _jextract__GdkEventTouchpadPinch.state(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventTouchpadPinch.state(_jextract_value, value.toInt()) }

    override fun toString(): String = 
        "_GdkEventTouchpadPinch(type=$type, window=$window, send_event=$send_event, phase=$phase, n_fingers=$n_fingers, time=$time, x=$x, y=$y, dx=$dx, dy=$dy, angle_delta=$angle_delta, scale=$scale, x_root=$x_root, state=$state)"

    companion object: KJnaAllocationCompanion<_GdkEventTouchpadPinch>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GdkEventTouchpadPinch> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GdkEventTouchpadPinch.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GdkEventTouchpadPinch {
            return _GdkEventTouchpadPinch(from.pointer)
        }
        override fun set(value: _GdkEventTouchpadPinch, pointer: KJnaTypedPointer<_GdkEventTouchpadPinch>) {
            pointer.pointer = value._jextract_value
        }
    }
}
