package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.convert
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GdkEventTouchpadSwipe as _jextract__GdkEventTouchpadSwipe
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.GdkEventType
import kjna.struct._GdkWindow

actual class _GdkEventTouchpadSwipe constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var type: GdkEventType
        get() = GdkEventType.entries.first { it.value == _jextract__GdkEventTouchpadSwipe.type(_jextract_value) }
        set(value) { _jextract__GdkEventTouchpadSwipe.type(_jextract_value, value.value) }
    actual var window: KJnaTypedPointer<_GdkWindow>?
        get() = _jextract__GdkEventTouchpadSwipe.window(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkWindow.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventTouchpadSwipe.window(_jextract_value, value?.pointer) }
    actual var send_event: Char
        get() = _jextract__GdkEventTouchpadSwipe.send_event(_jextract_value).convert()
        set(value) { _jextract__GdkEventTouchpadSwipe.send_event(_jextract_value, value.convert()) }
    actual var phase: Char
        get() = _jextract__GdkEventTouchpadSwipe.phase(_jextract_value).convert()
        set(value) { _jextract__GdkEventTouchpadSwipe.phase(_jextract_value, value.convert()) }
    actual var n_fingers: Char
        get() = _jextract__GdkEventTouchpadSwipe.n_fingers(_jextract_value).convert()
        set(value) { _jextract__GdkEventTouchpadSwipe.n_fingers(_jextract_value, value.convert()) }
    actual var time: UInt
        get() = _jextract__GdkEventTouchpadSwipe.time(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventTouchpadSwipe.time(_jextract_value, value.toInt()) }
    actual var x: Double
        get() = _jextract__GdkEventTouchpadSwipe.x(_jextract_value)
        set(value) { _jextract__GdkEventTouchpadSwipe.x(_jextract_value, value) }
    actual var y: Double
        get() = _jextract__GdkEventTouchpadSwipe.y(_jextract_value)
        set(value) { _jextract__GdkEventTouchpadSwipe.y(_jextract_value, value) }
    actual var dx: Double
        get() = _jextract__GdkEventTouchpadSwipe.dx(_jextract_value)
        set(value) { _jextract__GdkEventTouchpadSwipe.dx(_jextract_value, value) }
    actual var dy: Double
        get() = _jextract__GdkEventTouchpadSwipe.dy(_jextract_value)
        set(value) { _jextract__GdkEventTouchpadSwipe.dy(_jextract_value, value) }
    actual var x_root: Double
        get() = _jextract__GdkEventTouchpadSwipe.x_root(_jextract_value)
        set(value) { _jextract__GdkEventTouchpadSwipe.x_root(_jextract_value, value) }
    actual var state: UInt
        get() = _jextract__GdkEventTouchpadSwipe.state(_jextract_value).toUInt()
        set(value) { _jextract__GdkEventTouchpadSwipe.state(_jextract_value, value.toInt()) }

    override fun toString(): String = 
        "_GdkEventTouchpadSwipe(type=$type, window=$window, send_event=$send_event, phase=$phase, n_fingers=$n_fingers, time=$time, x=$x, y=$y, dx=$dx, dy=$dy, x_root=$x_root, state=$state)"

    companion object: KJnaAllocationCompanion<_GdkEventTouchpadSwipe>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GdkEventTouchpadSwipe> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GdkEventTouchpadSwipe.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GdkEventTouchpadSwipe {
            return _GdkEventTouchpadSwipe(from.pointer)
        }
        override fun set(value: _GdkEventTouchpadSwipe, pointer: KJnaTypedPointer<_GdkEventTouchpadSwipe>) {
            pointer.pointer = value._jextract_value
        }
    }
}
