package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.convert
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GdkEventWindowState as _jextract__GdkEventWindowState
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.GdkEventType
import kjna.enum.GdkWindowState
import kjna.struct._GdkWindow

actual class _GdkEventWindowState constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var type: GdkEventType
        get() = GdkEventType.entries.first { it.value == _jextract__GdkEventWindowState.type(_jextract_value) }
        set(value) { _jextract__GdkEventWindowState.type(_jextract_value, value.value) }
    actual var window: KJnaTypedPointer<_GdkWindow>?
        get() = _jextract__GdkEventWindowState.window(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GdkWindow.Companion).uncheckedCast() }
        set(value) { _jextract__GdkEventWindowState.window(_jextract_value, value?.pointer) }
    actual var send_event: Char
        get() = _jextract__GdkEventWindowState.send_event(_jextract_value).convert()
        set(value) { _jextract__GdkEventWindowState.send_event(_jextract_value, value.convert()) }
    actual var changed_mask: GdkWindowState
        get() = GdkWindowState.entries.first { it.value == _jextract__GdkEventWindowState.changed_mask(_jextract_value) }
        set(value) { _jextract__GdkEventWindowState.changed_mask(_jextract_value, value.value) }
    actual var new_window_state: GdkWindowState
        get() = GdkWindowState.entries.first { it.value == _jextract__GdkEventWindowState.new_window_state(_jextract_value) }
        set(value) { _jextract__GdkEventWindowState.new_window_state(_jextract_value, value.value) }

    override fun toString(): String = 
        "_GdkEventWindowState(type=$type, window=$window, send_event=$send_event, changed_mask=$changed_mask, new_window_state=$new_window_state)"

    companion object: KJnaAllocationCompanion<_GdkEventWindowState>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GdkEventWindowState> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GdkEventWindowState.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GdkEventWindowState {
            return _GdkEventWindowState(from.pointer)
        }
        override fun set(value: _GdkEventWindowState, pointer: KJnaTypedPointer<_GdkEventWindowState>) {
            pointer.pointer = value._jextract_value
        }
    }
}
