package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GtkWindow as _jextract__GtkWindow
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.struct._GtkBin
import kjna.struct._GtkWindowPrivate

actual class _GtkWindow constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual val bin: _GtkBin
        get() = _GtkBin(_jextract__GtkWindow.bin(_jextract_value))
    actual var priv: KJnaTypedPointer<_GtkWindowPrivate>?
        get() = _jextract__GtkWindow.priv(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GtkWindowPrivate.Companion).uncheckedCast() }
        set(value) { _jextract__GtkWindow.priv(_jextract_value, value?.pointer) }

    override fun toString(): String = 
        "_GtkWindow(bin=$bin, priv=$priv)"

    companion object: KJnaAllocationCompanion<_GtkWindow>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GtkWindow> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GtkWindow.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GtkWindow {
            return _GtkWindow(from.pointer)
        }
        override fun set(value: _GtkWindow, pointer: KJnaTypedPointer<_GtkWindow>) {
            pointer.pointer = value._jextract_value
        }
    }
}
