package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libmpv.jextract.mpv_byte_array as _jextract_mpv_byte_array
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment

actual class mpv_byte_array constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var data: KJnaPointer?
        get() = _jextract_mpv_byte_array.data(_jextract_value)?.let { KJnaPointer(it).uncheckedCast() }
        set(value) { _jextract_mpv_byte_array.data(_jextract_value, value?.pointer) }
    actual var size: ULong
        get() = _jextract_mpv_byte_array.size(_jextract_value).toULong()
        set(value) { _jextract_mpv_byte_array.size(_jextract_value, value.toLong()) }

    override fun toString(): String = 
        "mpv_byte_array(data=$data, size=$size)"

    companion object: KJnaAllocationCompanion<mpv_byte_array>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<mpv_byte_array> {
            return KJnaTypedPointer.ofNativeObject(_jextract_mpv_byte_array.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): mpv_byte_array {
            return mpv_byte_array(from.pointer)
        }
        override fun set(value: mpv_byte_array, pointer: KJnaTypedPointer<mpv_byte_array>) {
            pointer.pointer = value._jextract_value
        }
    }
}
