package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libmpv.jextract.mpv_event as _jextract_mpv_event
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.mpv_event_id

actual class mpv_event constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var event_id: mpv_event_id
        get() = mpv_event_id.entries.first { it.value == _jextract_mpv_event.event_id(_jextract_value) }
        set(value) { _jextract_mpv_event.event_id(_jextract_value, value.value) }
    actual var error: Int
        get() = _jextract_mpv_event.error(_jextract_value)
        set(value) { _jextract_mpv_event.error(_jextract_value, value) }
    actual var reply_userdata: ULong
        get() = _jextract_mpv_event.reply_userdata(_jextract_value).toULong()
        set(value) { _jextract_mpv_event.reply_userdata(_jextract_value, value.toLong()) }
    actual var data: KJnaPointer?
        get() = _jextract_mpv_event.data(_jextract_value)?.let { KJnaPointer(it).uncheckedCast() }
        set(value) { _jextract_mpv_event.data(_jextract_value, value?.pointer) }

    override fun toString(): String = 
        "mpv_event(event_id=$event_id, error=$error, reply_userdata=$reply_userdata, data=$data)"

    companion object: KJnaAllocationCompanion<mpv_event>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<mpv_event> {
            return KJnaTypedPointer.ofNativeObject(_jextract_mpv_event.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): mpv_event {
            return mpv_event(from.pointer)
        }
        override fun set(value: mpv_event, pointer: KJnaTypedPointer<mpv_event>) {
            pointer.pointer = value._jextract_value
        }
    }
}
