package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import gen.libmpv.jextract.mpv_event_end_file as _jextract_mpv_event_end_file
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.mpv_end_file_reason

actual class mpv_event_end_file constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var reason: mpv_end_file_reason
        get() = mpv_end_file_reason.entries.first { it.value == _jextract_mpv_event_end_file.reason(_jextract_value) }
        set(value) { _jextract_mpv_event_end_file.reason(_jextract_value, value.value) }
    actual var error: Int
        get() = _jextract_mpv_event_end_file.error(_jextract_value)
        set(value) { _jextract_mpv_event_end_file.error(_jextract_value, value) }
    actual var playlist_entry_id: Long
        get() = _jextract_mpv_event_end_file.playlist_entry_id(_jextract_value)
        set(value) { _jextract_mpv_event_end_file.playlist_entry_id(_jextract_value, value) }
    actual var playlist_insert_id: Long
        get() = _jextract_mpv_event_end_file.playlist_insert_id(_jextract_value)
        set(value) { _jextract_mpv_event_end_file.playlist_insert_id(_jextract_value, value) }
    actual var playlist_insert_num_entries: Int
        get() = _jextract_mpv_event_end_file.playlist_insert_num_entries(_jextract_value)
        set(value) { _jextract_mpv_event_end_file.playlist_insert_num_entries(_jextract_value, value) }

    override fun toString(): String = 
        "mpv_event_end_file(reason=$reason, error=$error, playlist_entry_id=$playlist_entry_id, playlist_insert_id=$playlist_insert_id, playlist_insert_num_entries=$playlist_insert_num_entries)"

    companion object: KJnaAllocationCompanion<mpv_event_end_file>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<mpv_event_end_file> {
            return KJnaTypedPointer.ofNativeObject(_jextract_mpv_event_end_file.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): mpv_event_end_file {
            return mpv_event_end_file(from.pointer)
        }
        override fun set(value: mpv_event_end_file, pointer: KJnaTypedPointer<mpv_event_end_file>) {
            pointer.pointer = value._jextract_value
        }
    }
}
