package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.getString
import dev.toastbits.kjna.runtime.memorySegment
import gen.libmpv.jextract.mpv_event_log_message as _jextract_mpv_event_log_message
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.mpv_log_level

actual class mpv_event_log_message constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var prefix: String?
        get() = _jextract_mpv_event_log_message.prefix(_jextract_value)?.getString()
        set(value) { _jextract_mpv_event_log_message.prefix(_jextract_value, value?.memorySegment(_mem_scope)) }
    actual var level: String?
        get() = _jextract_mpv_event_log_message.level(_jextract_value)?.getString()
        set(value) { _jextract_mpv_event_log_message.level(_jextract_value, value?.memorySegment(_mem_scope)) }
    actual var text: String?
        get() = _jextract_mpv_event_log_message.text(_jextract_value)?.getString()
        set(value) { _jextract_mpv_event_log_message.text(_jextract_value, value?.memorySegment(_mem_scope)) }
    actual var log_level: mpv_log_level
        get() = mpv_log_level.entries.first { it.value == _jextract_mpv_event_log_message.log_level(_jextract_value) }
        set(value) { _jextract_mpv_event_log_message.log_level(_jextract_value, value.value) }

    override fun toString(): String = 
        "mpv_event_log_message(prefix=$prefix, level=$level, text=$text, log_level=$log_level)"

    companion object: KJnaAllocationCompanion<mpv_event_log_message>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<mpv_event_log_message> {
            return KJnaTypedPointer.ofNativeObject(_jextract_mpv_event_log_message.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): mpv_event_log_message {
            return mpv_event_log_message(from.pointer)
        }
        override fun set(value: mpv_event_log_message, pointer: KJnaTypedPointer<mpv_event_log_message>) {
            pointer.pointer = value._jextract_value
        }
    }
}
