package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.getString
import dev.toastbits.kjna.runtime.memorySegment
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libmpv.jextract.mpv_event_property as _jextract_mpv_event_property
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.mpv_format

actual class mpv_event_property constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var name: String?
        get() = _jextract_mpv_event_property.name(_jextract_value)?.getString()
        set(value) { _jextract_mpv_event_property.name(_jextract_value, value?.memorySegment(_mem_scope)) }
    actual var format: mpv_format
        get() = mpv_format.entries.first { it.value == _jextract_mpv_event_property.format(_jextract_value) }
        set(value) { _jextract_mpv_event_property.format(_jextract_value, value.value) }
    actual var data: KJnaPointer?
        get() = _jextract_mpv_event_property.data(_jextract_value)?.let { KJnaPointer(it).uncheckedCast() }
        set(value) { _jextract_mpv_event_property.data(_jextract_value, value?.pointer) }

    override fun toString(): String = 
        "mpv_event_property(name=$name, format=$format, data=$data)"

    companion object: KJnaAllocationCompanion<mpv_event_property>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<mpv_event_property> {
            return KJnaTypedPointer.ofNativeObject(_jextract_mpv_event_property.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): mpv_event_property {
            return mpv_event_property(from.pointer)
        }
        override fun set(value: mpv_event_property, pointer: KJnaTypedPointer<mpv_event_property>) {
            pointer.pointer = value._jextract_value
        }
    }
}
