package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.getString
import dev.toastbits.kjna.runtime.memorySegment
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libmpv.jextract.mpv_node as _jextract_mpv_node
import gen.libmpv.jextract.mpv_node.u as _jextract_mpv_node_u
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.enum.mpv_format
import kjna.struct.mpv_byte_array
import kjna.struct.mpv_node_list

actual class mpv_node constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual val u: mpv_node_union_0 = mpv_node_union_0(_jextract_mpv_node.u(_jextract_value))
    
    actual var format: mpv_format
        get() = mpv_format.entries.first { it.value == _jextract_mpv_node.format(_jextract_value) }
        set(value) { _jextract_mpv_node.format(_jextract_value, value.value) }

    override fun toString(): String = 
        "mpv_node(u=$u, format=$format)"

    companion object: KJnaAllocationCompanion<mpv_node>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<mpv_node> {
            return KJnaTypedPointer.ofNativeObject(_jextract_mpv_node.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): mpv_node {
            return mpv_node(from.pointer)
        }
        override fun set(value: mpv_node, pointer: KJnaTypedPointer<mpv_node>) {
            pointer.pointer = value._jextract_value
        }
    }
}

actual class mpv_node_union_0 constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var string: String?
        get() = _jextract_mpv_node.u.string(_jextract_value)?.getString()
        set(value) { _jextract_mpv_node.u.string(_jextract_value, value?.memorySegment(_mem_scope)) }
    actual var flag: Int?
        get() = _jextract_mpv_node.u.flag(_jextract_value)
        set(value) { if (value != null) _jextract_mpv_node.u.flag(_jextract_value, value) }
    actual var int64: Long?
        get() = _jextract_mpv_node.u.int64(_jextract_value)
        set(value) { if (value != null) _jextract_mpv_node.u.int64(_jextract_value, value) }
    actual var double_: Double?
        get() = _jextract_mpv_node.u.double_(_jextract_value)
        set(value) { if (value != null) _jextract_mpv_node.u.double_(_jextract_value, value) }
    actual var list: KJnaTypedPointer<mpv_node_list>?
        get() = _jextract_mpv_node.u.list(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, mpv_node_list.Companion).uncheckedCast() }
        set(value) { if (value != null) _jextract_mpv_node.u.list(_jextract_value, value?.pointer) }
    actual var ba: KJnaTypedPointer<mpv_byte_array>?
        get() = _jextract_mpv_node.u.ba(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, mpv_byte_array.Companion).uncheckedCast() }
        set(value) { if (value != null) _jextract_mpv_node.u.ba(_jextract_value, value?.pointer) }
}
