package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libmpv.jextract.mpv_node_list as _jextract_mpv_node_list
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.struct.mpv_node

actual class mpv_node_list constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var num: Int
        get() = _jextract_mpv_node_list.num(_jextract_value)
        set(value) { _jextract_mpv_node_list.num(_jextract_value, value) }
    actual var values: KJnaTypedPointer<mpv_node>?
        get() = _jextract_mpv_node_list.values(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, mpv_node.Companion).uncheckedCast() }
        set(value) { _jextract_mpv_node_list.values(_jextract_value, value?.pointer) }
    actual var keys: KJnaTypedPointer<String>?
        get() = _jextract_mpv_node_list.keys(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, KJnaAllocationCompanion.ofPrimitive()).uncheckedCast() }
        set(value) { _jextract_mpv_node_list.keys(_jextract_value, value?.pointer) }

    override fun toString(): String = 
        "mpv_node_list(num=$num, values=$values, keys=$keys)"

    companion object: KJnaAllocationCompanion<mpv_node_list>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<mpv_node_list> {
            return KJnaTypedPointer.ofNativeObject(_jextract_mpv_node_list.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): mpv_node_list {
            return mpv_node_list(from.pointer)
        }
        override fun set(value: mpv_node_list, pointer: KJnaTypedPointer<mpv_node_list>) {
            pointer.pointer = value._jextract_value
        }
    }
}
