/*
 * Decompiled with CFR 0.152.
 */
package dev.treset.mcdl.java;

import dev.treset.mcdl.exception.FileDownloadException;
import dev.treset.mcdl.java.JavaFile;
import dev.treset.mcdl.java.JavaRuntimes;
import dev.treset.mcdl.util.DownloadStatus;
import dev.treset.mcdl.util.cache.Caching;
import java.io.File;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.function.Consumer;

public class JavaDL {
    private static final String JAVA_RUNTIME_URL = "https://launchermeta.mojang.com/v1/products/java-runtime/2ec0cc96c44e5a76b9c8b7c39df7210883d12871/all.json";
    private static Caching<HttpResponse<byte[]>> caching = null;

    public static void downloadJavaFiles(List<JavaFile> files, File baseDir) throws FileDownloadException {
        JavaDL.downloadJavaFiles(files, baseDir, status -> {});
    }

    public static void downloadJavaFiles(List<JavaFile> files, File baseDir, Consumer<DownloadStatus> statusCallback) throws FileDownloadException {
        JavaFile.downloadAll(files, baseDir, statusCallback);
    }

    public static void downloadJavaFile(JavaFile file, File baseDir) throws FileDownloadException {
        file.download(baseDir);
    }

    public static JavaRuntimes getJavaRuntimes() throws FileDownloadException {
        return JavaRuntimes.get();
    }

    public static List<JavaFile> getJavaFiles(String url) throws FileDownloadException {
        return JavaFile.getAll(url);
    }

    public static void setCaching(Caching<HttpResponse<byte[]>> caching) {
        JavaDL.caching = caching;
    }

    public static Caching<HttpResponse<byte[]>> getCaching() {
        return caching;
    }

    public static String getJavaRuntimeUrl() {
        return JAVA_RUNTIME_URL;
    }
}

