/*
 * Decompiled with CFR 0.152.
 */
package dev.treset.mcdl.java;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.treset.mcdl.exception.FileDownloadException;
import dev.treset.mcdl.java.JavaDL;
import dev.treset.mcdl.java.JavaDownload;
import dev.treset.mcdl.json.GenericJsonParsable;
import dev.treset.mcdl.json.JsonUtils;
import dev.treset.mcdl.json.SerializationException;
import dev.treset.mcdl.util.DownloadStatus;
import dev.treset.mcdl.util.FileUtil;
import dev.treset.mcdl.util.HttpUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class JavaFile
extends GenericJsonParsable {
    private transient String name;
    private boolean executable;
    private String type;
    private JavaDownload lzma;
    private JavaDownload raw;

    public JavaFile(String name, boolean executable, String type, JavaDownload lzma, JavaDownload raw) {
        this.name = name;
        this.executable = executable;
        this.type = type;
        this.lzma = lzma;
        this.raw = raw;
    }

    public static List<JavaFile> fromJson(String jsonManifest) throws SerializationException {
        JsonObject manifestObj = JsonUtils.getAsJsonObject((JsonElement)JsonUtils.parseJson((String)jsonManifest));
        JsonObject filesObj = JsonUtils.getAsJsonObject((JsonObject)manifestObj, (String)"files");
        Set files = JsonUtils.getMembers((JsonObject)filesObj);
        if (files != null) {
            return files.stream().map(f -> {
                try {
                    return JavaFile.fromJsonObject((String)f.getKey(), JsonUtils.getAsJsonObject((JsonElement)((JsonElement)f.getValue())));
                }
                catch (SerializationException e) {
                    return null;
                }
            }).toList();
        }
        return List.of();
    }

    public static JavaFile fromJsonObject(String name, JsonObject jsonObject) throws SerializationException {
        JavaFile file = (JavaFile)((Object)JsonUtils.getGson().fromJson((JsonElement)jsonObject, JavaFile.class));
        JsonObject downloadsObj = JsonUtils.getAsJsonObject((JsonObject)jsonObject, (String)"downloads");
        file.setName(name);
        file.setLzma(JavaDownload.fromJsonObject(JsonUtils.getAsJsonObject((JsonObject)downloadsObj, (String)"lzma")));
        file.setRaw(JavaDownload.fromJsonObject(JsonUtils.getAsJsonObject((JsonObject)downloadsObj, (String)"raw")));
        return file;
    }

    public static List<JavaFile> getAll(String url) throws FileDownloadException {
        try {
            return JavaFile.fromJson(HttpUtil.getString((String)url, JavaDL.getCaching()));
        }
        catch (SerializationException e) {
            throw new FileDownloadException("Failed to parse java file", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new FileDownloadException("Failed to download java file", (Exception)e);
        }
    }

    public static void downloadAll(List<JavaFile> files, File baseDir, Consumer<DownloadStatus> onStatus) throws FileDownloadException {
        if (!baseDir.isDirectory() || files == null || files.isEmpty()) {
            throw new FileDownloadException("Unmet requirements for java download");
        }
        int size = files.size();
        int current = 0;
        for (JavaFile file : files) {
            if (onStatus != null) {
                onStatus.accept(new DownloadStatus(++current, size, file.getName()));
            }
            try {
                file.download(baseDir);
            }
            catch (FileDownloadException e) {
                throw new FileDownloadException("Failed to download java files", (Exception)((Object)e));
            }
        }
    }

    public void download(File baseDir) throws FileDownloadException {
        if (this.getType() == null || this.getType().isBlank() || this.getName() == null || this.getName().isBlank() || this.isFile() && (this.getRaw() == null || this.getRaw().getUrl() == null || this.getRaw().getUrl().isBlank()) || baseDir == null || !baseDir.isDirectory()) {
            throw new FileDownloadException("Unmet requirements for java file download: file=" + this.getName());
        }
        File outDir = null;
        if (this.isDir()) {
            outDir = new File(baseDir, this.getName());
        } else if (this.isFile()) {
            outDir = new File(baseDir, this.getName().substring(0, this.getName().lastIndexOf(47) == -1 ? this.getName().length() : this.getName().lastIndexOf(47)));
        }
        if (outDir == null || !outDir.isDirectory() && !outDir.mkdirs()) {
            throw new FileDownloadException("Unable to make required dirs for file download: file=" + this.getName());
        }
        if (this.isDir()) {
            return;
        }
        if (this.isFile()) {
            URL downloadUrl;
            try {
                downloadUrl = new URL(this.getRaw().getUrl());
            }
            catch (MalformedURLException e) {
                throw new FileDownloadException("Unable to convert download url: file=" + this.getName(), (Exception)e);
            }
            File outFile = new File(outDir, this.getName().substring(this.getName().lastIndexOf(47) == -1 ? 0 : this.getName().lastIndexOf(47)));
            FileUtil.downloadFile((URL)downloadUrl, (File)outFile, JavaDL.getCaching());
            return;
        }
        throw new FileDownloadException("Unable to determine file type: file=" + this.getName());
    }

    public boolean isFile() {
        return Objects.equals(this.getType(), "file");
    }

    public boolean isDir() {
        return Objects.equals(this.getType(), "directory");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public void setExecutable(boolean executable) {
        this.executable = executable;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public JavaDownload getLzma() {
        return this.lzma;
    }

    public void setLzma(JavaDownload lzma) {
        this.lzma = lzma;
    }

    public JavaDownload getRaw() {
        return this.raw;
    }

    public void setRaw(JavaDownload raw) {
        this.raw = raw;
    }
}

