/*
 * Decompiled with CFR 0.152.
 */
package dev.treset.mcdl.java;

import dev.treset.mcdl.exception.FileDownloadException;
import dev.treset.mcdl.java.JavaDL;
import dev.treset.mcdl.java.JavaRuntimeRelease;
import dev.treset.mcdl.json.SerializationException;
import dev.treset.mcdl.util.HttpUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaRuntimes
extends HashMap<String, Map<String, List<JavaRuntimeRelease>>> {
    public JavaRuntimes(Map<String, Map<String, List<JavaRuntimeRelease>>> content) {
        this.putAll(content);
    }

    public static JavaRuntimes fromJson(String json) throws SerializationException {
        Map<String, Map<String, List<JavaRuntimeRelease>>> runtimes = JavaRuntimeRelease.fromJson(json);
        return new JavaRuntimes(runtimes);
    }

    public static JavaRuntimes get() throws FileDownloadException {
        try {
            return JavaRuntimes.fromJson(HttpUtil.getString((String)JavaDL.getJavaRuntimeUrl(), JavaDL.getCaching()));
        }
        catch (SerializationException e) {
            throw new FileDownloadException("Failed to parse runtimes file", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new FileDownloadException("Failed to download runtimes file", (Exception)e);
        }
    }

    public Map<String, List<JavaRuntimeRelease>> getOsReleases(String os) {
        return (Map)this.get(os);
    }

    public List<JavaRuntimeRelease> getReleases(String os, String version) {
        return (List)((Map)this.get(os)).get(version);
    }
}

