/*
 * Decompiled with CFR 0.152.
 */
package dev.turingcomplete.kotlinonetimepassword;

import dev.turingcomplete.kotlinonetimepassword.HmacAlgorithm;
import dev.turingcomplete.kotlinonetimepassword.RandomSecretGenerator;
import dev.turingcomplete.kotlinonetimepassword.TimeBasedOneTimePasswordConfig;
import dev.turingcomplete.kotlinonetimepassword.TimeBasedOneTimePasswordGenerator;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.codec.binary.Base32;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/turingcomplete/kotlinonetimepassword/GoogleAuthenticator;", "", "base32secret", "", "(Ljava/lang/String;)V", "timeBasedOneTimePasswordGenerator", "Ldev/turingcomplete/kotlinonetimepassword/TimeBasedOneTimePasswordGenerator;", "generate", "timestamp", "Ljava/util/Date;", "isValid", "", "code", "Companion", "kotlin-onetimepassword"})
public final class GoogleAuthenticator {
    private final TimeBasedOneTimePasswordGenerator timeBasedOneTimePasswordGenerator;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String generate(@NotNull Date timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        return this.timeBasedOneTimePasswordGenerator.generate(timestamp);
    }

    public static /* synthetic */ String generate$default(GoogleAuthenticator googleAuthenticator, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            date = new Date(System.currentTimeMillis());
        }
        return googleAuthenticator.generate(date);
    }

    public final boolean isValid(@NotNull String code, @NotNull Date timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        return Intrinsics.areEqual((Object)code, (Object)this.generate(timestamp));
    }

    public static /* synthetic */ boolean isValid$default(GoogleAuthenticator googleAuthenticator, String string, Date date, int n, Object object) {
        if ((n & 2) != 0) {
            date = new Date(System.currentTimeMillis());
        }
        return googleAuthenticator.isValid(string, date);
    }

    public GoogleAuthenticator(@NotNull String base32secret) {
        Intrinsics.checkParameterIsNotNull((Object)base32secret, (String)"base32secret");
        HmacAlgorithm hmacAlgorithm = HmacAlgorithm.SHA1;
        TimeBasedOneTimePasswordConfig config = new TimeBasedOneTimePasswordConfig(30L, TimeUnit.SECONDS, 6, hmacAlgorithm);
        byte[] byArray = new Base32().decode(base32secret);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base32().decode(base32secret)");
        this.timeBasedOneTimePasswordGenerator = new TimeBasedOneTimePasswordGenerator(byArray, config);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Ldev/turingcomplete/kotlinonetimepassword/GoogleAuthenticator$Companion;", "", "()V", "createRandomSecret", "", "kotlin-onetimepassword"})
    public static final class Companion {
        @NotNull
        public final String createRandomSecret() {
            byte[] randomSecret = new RandomSecretGenerator().createRandomSecret(10);
            String string = new Base32().encodeToString(randomSecret);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Base32().encodeToString(randomSecret)");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

