/*
 * Decompiled with CFR 0.152.
 */
package dev.turingcomplete.kotlinonetimepassword;

import dev.turingcomplete.kotlinonetimepassword.HmacOneTimePasswordGenerator;
import dev.turingcomplete.kotlinonetimepassword.TimeBasedOneTimePasswordConfig;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/turingcomplete/kotlinonetimepassword/TimeBasedOneTimePasswordGenerator;", "", "secret", "", "config", "Ldev/turingcomplete/kotlinonetimepassword/TimeBasedOneTimePasswordConfig;", "([BLdev/turingcomplete/kotlinonetimepassword/TimeBasedOneTimePasswordConfig;)V", "hmacOneTimePasswordGenerator", "Ldev/turingcomplete/kotlinonetimepassword/HmacOneTimePasswordGenerator;", "generate", "", "timestamp", "Ljava/util/Date;", "isValid", "", "code", "kotlin-onetimepassword"})
public class TimeBasedOneTimePasswordGenerator {
    private final HmacOneTimePasswordGenerator hmacOneTimePasswordGenerator;
    private final byte[] secret;
    private final TimeBasedOneTimePasswordConfig config;

    @NotNull
    public final String generate(@NotNull Date timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        long counter = this.config.getTimeStep() == 0L ? 0L : timestamp.getTime() / TimeUnit.MILLISECONDS.convert(this.config.getTimeStep(), this.config.getTimeStepUnit());
        return this.hmacOneTimePasswordGenerator.generate(counter);
    }

    public static /* synthetic */ String generate$default(TimeBasedOneTimePasswordGenerator timeBasedOneTimePasswordGenerator, Date date, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generate");
        }
        if ((n & 1) != 0) {
            date = new Date(System.currentTimeMillis());
        }
        return timeBasedOneTimePasswordGenerator.generate(date);
    }

    public final boolean isValid(@NotNull String code, @NotNull Date timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        return Intrinsics.areEqual((Object)code, (Object)this.generate(timestamp));
    }

    public static /* synthetic */ boolean isValid$default(TimeBasedOneTimePasswordGenerator timeBasedOneTimePasswordGenerator, String string, Date date, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isValid");
        }
        if ((n & 2) != 0) {
            date = new Date(System.currentTimeMillis());
        }
        return timeBasedOneTimePasswordGenerator.isValid(string, date);
    }

    public TimeBasedOneTimePasswordGenerator(@NotNull byte[] secret, @NotNull TimeBasedOneTimePasswordConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)secret, (String)"secret");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.secret = secret;
        this.config = config;
        this.hmacOneTimePasswordGenerator = new HmacOneTimePasswordGenerator(this.secret, this.config);
    }
}

