/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.bank.spring.boot.starter.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.vality.adapter.common.mapper.SimpleErrorMapping;
import dev.vality.adapter.common.mapper.SimpleObjectMapper;
import dev.vality.error.mapping.ErrorMapping;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration
public class AppConfiguration {
    @Value(value="${error-mapping.file}")
    private Resource errorMappingFilePath;
    @Value(value="${error-mapping.patternReason:\"'%s' - '%s'\"}")
    private String errorMappingPattern;

    @Bean
    public ErrorMapping errorMapping() throws IOException {
        return new SimpleErrorMapping(this.errorMappingFilePath, this.errorMappingPattern).createErrorMapping();
    }

    @Bean
    public ObjectMapper objectMapper() {
        return new SimpleObjectMapper().createSimpleObjectMapperFactory();
    }
}

