/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.bank.spring.boot.starter.configuration;

import dev.vality.adapter.common.component.NetworkFilterComponent;
import org.apache.catalina.connector.Connector;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class NetworkConfiguration {
    @Value(value="${server.rest.port}")
    private int restPort;
    @Value(value="/${server.rest.endpoint}/")
    private String restEndpoint;

    @Bean
    public FilterRegistrationBean externalPortRestrictingFilter() {
        return new NetworkFilterComponent().externalPortRestrictingFilter(this.restPort, this.restEndpoint);
    }

    @Bean
    public FilterRegistrationBean woodyFilter() {
        return new NetworkFilterComponent().woodyFilter(this.restPort, this.restEndpoint);
    }

    @Bean
    public ServletWebServerFactory servletContainer() {
        TomcatServletWebServerFactory tomcat = new TomcatServletWebServerFactory();
        Connector connector = new Connector();
        connector.setPort(this.restPort);
        tomcat.addAdditionalTomcatConnectors(new Connector[]{connector});
        return tomcat;
    }
}

