/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.helpers.hellgate;

import dev.vality.adapter.helpers.hellgate.exception.HellgateException;
import dev.vality.damsel.proxy_provider.ProviderProxyHostSrv;
import java.nio.ByteBuffer;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HellgateAdapterClient {
    private static final Logger log = LoggerFactory.getLogger(HellgateAdapterClient.class);
    private final ProviderProxyHostSrv.Iface providerProxyHostSrv;

    public ByteBuffer processPaymentCallback(String tag, ByteBuffer callback) {
        log.info("processPaymentCallback start with tag {}", (Object)tag);
        try {
            ByteBuffer callbackResponse = this.providerProxyHostSrv.processPaymentCallback(tag, callback);
            log.info("processPaymentCallback finish with tag {}", (Object)tag);
            return callbackResponse;
        }
        catch (TException ex) {
            throw new HellgateException(String.format("Exception in processPaymentCallback with tag: %s", tag), ex);
        }
    }

    public ByteBuffer processRecurrentTokenCallback(String tag, ByteBuffer callback) {
        log.info("processRecurrentTokenCallback start with tag {}", (Object)tag);
        try {
            ByteBuffer callbackResponse = this.providerProxyHostSrv.processRecurrentTokenCallback(tag, callback);
            log.info("processRecurrentTokenCallback finish with tag {}", (Object)tag);
            return callbackResponse;
        }
        catch (TException ex) {
            throw new HellgateException(String.format("Exception in processRecurrentTokenCallback with tag: %s", tag), ex);
        }
    }

    public HellgateAdapterClient(ProviderProxyHostSrv.Iface providerProxyHostSrv) {
        this.providerProxyHostSrv = providerProxyHostSrv;
    }
}

