/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.cds;

import dev.vality.adapter.common.exception.CdsStorageException;
import dev.vality.adapter.common.utils.cds.creators.BankCardExtractor;
import dev.vality.adapter.common.utils.cds.model.CardDataProxyModel;
import dev.vality.adapter.common.utils.damsel.extractors.ProxyProviderPackageExtractors;
import dev.vality.cds.storage.CardData;
import dev.vality.cds.storage.SessionData;
import dev.vality.cds.storage.StorageSrv;
import dev.vality.damsel.domain.BankCard;
import dev.vality.damsel.domain.DisposablePaymentResource;
import dev.vality.damsel.proxy_provider.PaymentContext;
import dev.vality.damsel.proxy_provider.PaymentResource;
import dev.vality.damsel.proxy_provider.RecurrentTokenContext;
import dev.vality.damsel.withdrawals.domain.Destination;
import dev.vality.damsel.withdrawals.provider_adapter.Withdrawal;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;

public class CdsClientStorage {
    private static final Logger log = LoggerFactory.getLogger(CdsClientStorage.class);
    private final StorageSrv.Iface storageSrv;

    @Cacheable(value={"cardData"})
    public CardData getCardData(String token) {
        log.info("Get card data by token: {}", (Object)token);
        try {
            return this.storageSrv.getCardData(token);
        }
        catch (TException ex) {
            throw new CdsStorageException(String.format("Can't get card data with token: %s", token), ex);
        }
    }

    public CardDataProxyModel getCardData(PaymentContext context, PaymentResource paymentResource) {
        if (paymentResource.isSetDisposablePaymentResource()) {
            String cardToken = ProxyProviderPackageExtractors.extractBankCardToken(paymentResource);
            CardData cardData = this.getCardData(cardToken);
            BankCard bankCard = ProxyProviderPackageExtractors.extractBankCard(context);
            return BankCardExtractor.initCardDataProxyModel(bankCard, cardData);
        }
        return this.getCardData(context);
    }

    public CardDataProxyModel getCardData(PaymentContext context) {
        CardData cardData = this.getCardData(ProxyProviderPackageExtractors.extractBankCardToken(ProxyProviderPackageExtractors.extractPaymentResource(context)));
        BankCard bankCard = ProxyProviderPackageExtractors.extractBankCard(context.getPaymentInfo());
        return BankCardExtractor.initCardDataProxyModel(bankCard, cardData);
    }

    public CardDataProxyModel getCardData(Withdrawal withdrawal) {
        Destination destination = withdrawal.getDestination();
        if (!destination.isSetBankCard()) {
            throw new CdsStorageException("Token must be set for card data, withdrawalId " + withdrawal.getId());
        }
        BankCard bankCard = destination.getBankCard();
        return BankCardExtractor.initCardDataProxyModel(bankCard, this.getCardData(bankCard.getToken()));
    }

    public CardDataProxyModel getCardData(RecurrentTokenContext context) {
        DisposablePaymentResource disposablePaymentResource = ProxyProviderPackageExtractors.extractDisposablePaymentResource(context);
        if (!disposablePaymentResource.isSetPaymentSessionId()) {
            throw new CdsStorageException("Session Id must be set, recurrentId " + ProxyProviderPackageExtractors.extractRecurrentId(context));
        }
        BankCard bankCard = ProxyProviderPackageExtractors.extractBankCard(context);
        return BankCardExtractor.initCardDataProxyModel(bankCard, this.getCardData(ProxyProviderPackageExtractors.extractBankCardToken(disposablePaymentResource)));
    }

    public CardDataProxyModel getCardData(PaymentResource paymentResource) {
        if (!paymentResource.isSetDisposablePaymentResource() && !paymentResource.getDisposablePaymentResource().getPaymentTool().isSetBankCard()) {
            throw new CdsStorageException("Exception when getCardData CdsClientStorage!");
        }
        BankCard bankCard = paymentResource.getDisposablePaymentResource().getPaymentTool().getBankCard();
        return BankCardExtractor.initCardDataProxyModel(bankCard, this.getCardData(bankCard.getToken()));
    }

    public SessionData getSessionData(PaymentContext context) {
        DisposablePaymentResource disposablePaymentResource = ProxyProviderPackageExtractors.extractDisposablePaymentResource(context);
        if (!disposablePaymentResource.isSetPaymentSessionId()) {
            throw new CdsStorageException("Session must be set for session data, invoiceId " + ProxyProviderPackageExtractors.extractInvoiceId(context));
        }
        return this.getSessionDataBySessionId(disposablePaymentResource.getPaymentSessionId());
    }

    public SessionData getSessionData(RecurrentTokenContext context) {
        DisposablePaymentResource disposablePaymentResource = ProxyProviderPackageExtractors.extractDisposablePaymentResource(context);
        if (!disposablePaymentResource.isSetPaymentSessionId()) {
            throw new CdsStorageException("Session Id must be set, recurrentId " + ProxyProviderPackageExtractors.extractRecurrentId(context));
        }
        return this.getSessionDataBySessionId(disposablePaymentResource.getPaymentSessionId());
    }

    @Cacheable(value={"sessionData"})
    public SessionData getSessionDataBySessionId(String sessionId) {
        try {
            return this.storageSrv.getSessionData(sessionId);
        }
        catch (TException ex) {
            throw new CdsStorageException("Can't get session data by session Id " + sessionId, ex);
        }
    }

    public CdsClientStorage(StorageSrv.Iface storageSrv) {
        this.storageSrv = storageSrv;
    }
}

