/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.component;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

public class LoggingInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LoggingInterceptor.class);
    private AtomicInteger requestNumberSequence = new AtomicInteger(0);

    public LoggingInterceptor() {
        log.warn("Warning! LoggingInterceptor can write bank card data in RAW");
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        int requestNumber = this.requestNumberSequence.incrementAndGet();
        this.logRequest(requestNumber, request, body);
        ClientHttpResponse response = execution.execute(request, body);
        response = new BufferedClientHttpResponse(response);
        this.logResponse(requestNumber, response);
        return response;
    }

    private void logRequest(int requestNumber, HttpRequest request, byte[] body) {
        if (log.isDebugEnabled()) {
            String prefix = requestNumber + " > ";
            log.debug("{} Request: {} {}", new Object[]{prefix, request.getMethod(), request.getURI()});
            log.debug("{} Headers: {}", (Object)prefix, (Object)request.getHeaders());
            if (body.length > 0) {
                log.debug("{} Body: \n{}", (Object)prefix, (Object)new String(body, StandardCharsets.UTF_8));
            }
        }
    }

    private void logResponse(int requestNumber, ClientHttpResponse response) throws IOException {
        if (log.isDebugEnabled()) {
            String prefix = requestNumber + " < ";
            log.debug("{} Response: {} {} {}", new Object[]{prefix, response.getStatusCode(), response.getStatusCode().name(), response.getStatusText()});
            log.debug("{} Headers: {}", (Object)prefix, (Object)response.getHeaders());
            String body = StreamUtils.copyToString((InputStream)response.getBody(), (Charset)StandardCharsets.UTF_8);
            if (body.length() > 0) {
                log.debug("{} Body: \n{}", (Object)prefix, (Object)body);
            }
        }
    }

    private class BufferedClientHttpResponse
    implements ClientHttpResponse {
        private final ClientHttpResponse response;
        private byte[] body;

        public BufferedClientHttpResponse(ClientHttpResponse response) {
            this.response = response;
        }

        public HttpStatus getStatusCode() throws IOException {
            return this.response.getStatusCode();
        }

        public int getRawStatusCode() throws IOException {
            return this.response.getRawStatusCode();
        }

        public String getStatusText() throws IOException {
            return this.response.getStatusText();
        }

        public void close() {
            this.response.close();
        }

        public InputStream getBody() throws IOException {
            if (this.body == null) {
                this.body = StreamUtils.copyToByteArray((InputStream)this.response.getBody());
            }
            return new ByteArrayInputStream(this.body);
        }

        public HttpHeaders getHeaders() {
            return this.response.getHeaders();
        }
    }
}

