/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.handler.callback;

import dev.vality.adapter.common.enums.Step;
import dev.vality.adapter.common.handler.callback.CallbackHandler;
import dev.vality.adapter.common.model.AdapterContext;
import dev.vality.adapter.common.model.Callback;
import dev.vality.adapter.common.state.deserializer.AdapterDeserializer;
import dev.vality.adapter.common.state.deserializer.CallbackDeserializer;
import dev.vality.adapter.common.state.serializer.AdapterSerializer;
import dev.vality.adapter.common.state.utils.AdapterStateUtils;
import dev.vality.adapter.common.utils.damsel.creators.BasePackageCreators;
import dev.vality.adapter.common.utils.damsel.creators.ProxyProviderPackageCreators;
import dev.vality.damsel.proxy_provider.RecurrentTokenCallbackResult;
import dev.vality.damsel.proxy_provider.RecurrentTokenContext;
import dev.vality.damsel.proxy_provider.RecurrentTokenIntent;
import dev.vality.damsel.proxy_provider.RecurrentTokenProxyResult;
import dev.vality.damsel.proxy_provider.SleepIntent;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecurrentTokenCallbackHandler
implements CallbackHandler<RecurrentTokenCallbackResult, RecurrentTokenContext> {
    private static final Logger log = LoggerFactory.getLogger(RecurrentTokenCallbackHandler.class);
    private final AdapterDeserializer adapterDeserializer;
    private final AdapterSerializer adapterSerializer;
    private final CallbackDeserializer callbackDeserializer;

    @Override
    public RecurrentTokenCallbackResult handleCallback(ByteBuffer callback, RecurrentTokenContext context) {
        AdapterContext adapterContext = AdapterStateUtils.getAdapterContext(context, this.adapterDeserializer);
        adapterContext.setStep(Step.GENERATE_TOKEN_FINISH_THREE_DS);
        Callback callbackObj = this.callbackDeserializer.read(callback.array());
        adapterContext.setPaRes(callbackObj.getPaRes());
        adapterContext.setMd(callbackObj.getMd());
        byte[] callbackResponse = new byte[]{};
        return ProxyProviderPackageCreators.createRecurrentTokenCallbackResult(callbackResponse, new RecurrentTokenProxyResult().setIntent(RecurrentTokenIntent.sleep((SleepIntent)ProxyProviderPackageCreators.createSleepIntent(BasePackageCreators.createTimerTimeout(0)))).setNextState(this.adapterSerializer.writeByte(adapterContext)));
    }

    public RecurrentTokenCallbackHandler(AdapterDeserializer adapterDeserializer, AdapterSerializer adapterSerializer, CallbackDeserializer callbackDeserializer) {
        this.adapterDeserializer = adapterDeserializer;
        this.adapterSerializer = adapterSerializer;
        this.callbackDeserializer = callbackDeserializer;
    }
}

