/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.logback.mask;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.fasterxml.jackson.core.JsonGenerator;
import dev.vality.adapter.common.logback.mask.MaskingMessageWithPattern;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.composite.JsonWritingUtils;
import net.logstash.logback.fieldnames.LogstashFieldNames;

public class PatternMaskingMessageJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent>
implements FieldNamesAware<LogstashFieldNames> {
    private Pattern multilinePattern;
    private List<String> maskPatterns = new ArrayList<String>();
    private static final String FIELD_MESSAGE = "message";
    private static final String DELIMITER = "|";

    public void addMaskPattern(String maskPattern) {
        this.maskPatterns.add(maskPattern);
        this.multilinePattern = Pattern.compile(String.join((CharSequence)DELIMITER, this.maskPatterns), 8);
    }

    public PatternMaskingMessageJsonProvider() {
        this.setFieldName(FIELD_MESSAGE);
    }

    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        JsonWritingUtils.writeStringField((JsonGenerator)generator, (String)this.getFieldName(), (String)MaskingMessageWithPattern.maskMessage(event.getFormattedMessage(), this.multilinePattern));
    }

    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.setFieldName(fieldNames.getMessage());
    }
}

