/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.logback.mdc;

import dev.vality.damsel.domain.TransactionInfo;
import dev.vality.damsel.proxy_provider.PaymentContext;
import dev.vality.damsel.proxy_provider.RecurrentTokenContext;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.MDC;

public class MdcContext {
    public static void mdcPutContext(RecurrentTokenContext context, String[] fieldsToPutInMdc) {
        TransactionInfo transactionInfo = context.getTokenInfo().getTrx();
        MdcContext.mdcPutContextTransactionInfo(transactionInfo, fieldsToPutInMdc);
    }

    public static void mdcPutContext(PaymentContext context, String[] fieldsToPutInMdc) {
        TransactionInfo transactionInfo = context.getPaymentInfo().getPayment().getTrx();
        MdcContext.mdcPutContextTransactionInfo(transactionInfo, fieldsToPutInMdc);
    }

    public static void mdcPutContext(PaymentContext context) {
        TransactionInfo transactionInfo = context.getPaymentInfo().getPayment().getTrx();
        MdcContext.mdcPutContextTransactionInfo(transactionInfo);
    }

    public static void mdcPutContext(RecurrentTokenContext context) {
        TransactionInfo transactionInfo = context.getTokenInfo().getTrx();
        MdcContext.mdcPutContextTransactionInfo(transactionInfo);
    }

    public static void mdcPutContextTransactionInfo(TransactionInfo transactionInfo, String[] fieldsToPutInMdc) {
        if (transactionInfo != null) {
            Map trxextra = transactionInfo.getExtra();
            for (String field : fieldsToPutInMdc) {
                MDC.put((String)field, (String)((String)trxextra.get(field)));
            }
        }
    }

    public static void mdcPutContextTransactionInfo(TransactionInfo transactionInfo) {
        if (transactionInfo != null) {
            Map trxextra = transactionInfo.getExtra();
            String maskPattern = "\\b\\d{6}([\\d\\s]{2,9})\\d{4}\\b";
            Pattern pattern = Pattern.compile(maskPattern);
            for (Map.Entry extra : trxextra.entrySet()) {
                if (!pattern.matcher((CharSequence)extra.getValue()).find()) continue;
                MDC.put((String)((String)extra.getKey()), (String)((String)extra.getValue()));
            }
        }
    }

    public static void mdcRemoveContext(String[] fieldsToPutInMdc) {
        for (String field : fieldsToPutInMdc) {
            MDC.remove((String)field);
        }
    }

    private MdcContext() {
    }
}

