/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.state.backoff;

import dev.vality.adapter.common.state.backoff.BackOff;
import dev.vality.adapter.common.state.backoff.BackOffExecution;

public class ExponentialBackOff
implements BackOff {
    public static final Integer DEFAULT_MUTIPLIER = 2;
    public static final Integer DEFAULT_INITIAL_INTERVAL = 2;
    public static final Integer DEFAULT_MAX_INTERVAL = 300;
    private Integer multiplier = DEFAULT_MUTIPLIER;
    private Integer initialInterval = DEFAULT_INITIAL_INTERVAL;
    private Integer maxInterval = DEFAULT_MAX_INTERVAL;
    private Long startTime;
    private Long currentTime;

    public ExponentialBackOff(Long startTime, Long currentTime, Integer multiplier, Integer initialInterval, Integer maxInterval) {
        this.startTime = startTime;
        this.currentTime = currentTime;
        this.multiplier = multiplier;
        this.initialInterval = initialInterval;
        this.maxInterval = maxInterval;
    }

    @Override
    public BackOffExecution start() {
        return new ExponentialBackOffExecution();
    }

    public Integer getMultiplier() {
        return this.multiplier;
    }

    public Integer getInitialInterval() {
        return this.initialInterval;
    }

    public Integer getMaxInterval() {
        return this.maxInterval;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getCurrentTime() {
        return this.currentTime;
    }

    public void setMultiplier(Integer multiplier) {
        this.multiplier = multiplier;
    }

    public void setInitialInterval(Integer initialInterval) {
        this.initialInterval = initialInterval;
    }

    public void setMaxInterval(Integer maxInterval) {
        this.maxInterval = maxInterval;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public void setCurrentTime(Long currentTime) {
        this.currentTime = currentTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExponentialBackOff)) {
            return false;
        }
        ExponentialBackOff other = (ExponentialBackOff)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$multiplier = this.getMultiplier();
        Integer other$multiplier = other.getMultiplier();
        if (this$multiplier == null ? other$multiplier != null : !((Object)this$multiplier).equals(other$multiplier)) {
            return false;
        }
        Integer this$initialInterval = this.getInitialInterval();
        Integer other$initialInterval = other.getInitialInterval();
        if (this$initialInterval == null ? other$initialInterval != null : !((Object)this$initialInterval).equals(other$initialInterval)) {
            return false;
        }
        Integer this$maxInterval = this.getMaxInterval();
        Integer other$maxInterval = other.getMaxInterval();
        if (this$maxInterval == null ? other$maxInterval != null : !((Object)this$maxInterval).equals(other$maxInterval)) {
            return false;
        }
        Long this$startTime = this.getStartTime();
        Long other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Long this$currentTime = this.getCurrentTime();
        Long other$currentTime = other.getCurrentTime();
        return !(this$currentTime == null ? other$currentTime != null : !((Object)this$currentTime).equals(other$currentTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExponentialBackOff;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $multiplier = this.getMultiplier();
        result = result * 59 + ($multiplier == null ? 43 : ((Object)$multiplier).hashCode());
        Integer $initialInterval = this.getInitialInterval();
        result = result * 59 + ($initialInterval == null ? 43 : ((Object)$initialInterval).hashCode());
        Integer $maxInterval = this.getMaxInterval();
        result = result * 59 + ($maxInterval == null ? 43 : ((Object)$maxInterval).hashCode());
        Long $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Long $currentTime = this.getCurrentTime();
        result = result * 59 + ($currentTime == null ? 43 : ((Object)$currentTime).hashCode());
        return result;
    }

    public String toString() {
        return "ExponentialBackOff(multiplier=" + this.getMultiplier() + ", initialInterval=" + this.getInitialInterval() + ", maxInterval=" + this.getMaxInterval() + ", startTime=" + this.getStartTime() + ", currentTime=" + this.getCurrentTime() + ")";
    }

    public ExponentialBackOff() {
    }

    private class ExponentialBackOffExecution
    implements BackOffExecution {
        private ExponentialBackOffExecution() {
        }

        @Override
        public Long nextBackOff() {
            if (ExponentialBackOff.this.currentTime.equals(ExponentialBackOff.this.startTime)) {
                return (long)ExponentialBackOff.this.initialInterval;
            }
            long nextBackOff = this.computeNextInterval(ExponentialBackOff.this.multiplier, ExponentialBackOff.this.startTime, ExponentialBackOff.this.currentTime);
            if (nextBackOff > (long)ExponentialBackOff.this.maxInterval.intValue()) {
                nextBackOff = ExponentialBackOff.this.maxInterval.intValue();
            }
            return nextBackOff;
        }

        private long computeNextInterval(int multiplier, Long startTime, Long currentTime) {
            long diff = (currentTime - startTime) / 1000L;
            if (diff < 1L || multiplier == 1) {
                return ExponentialBackOff.this.initialInterval.intValue();
            }
            long result = ExponentialBackOff.this.initialInterval.intValue();
            int step = 0;
            while (diff >= result) {
                long pow = (long)Math.pow(multiplier, step++);
                result = (long)ExponentialBackOff.this.initialInterval.intValue() * pow;
            }
            return result;
        }
    }
}

