/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.state.deserializer;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.vality.adapter.common.model.AdapterContext;
import dev.vality.adapter.common.state.deserializer.DeserializationException;
import dev.vality.adapter.common.state.deserializer.Deserializer;
import java.io.IOException;

public class AdapterDeserializer
implements Deserializer<AdapterContext> {
    private final ObjectMapper mapper;

    @Override
    public AdapterContext read(byte[] data) {
        if (data == null) {
            return new AdapterContext();
        }
        try {
            return (AdapterContext)this.getMapper().readValue(data, AdapterContext.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public AdapterContext read(String data) {
        throw new DeserializationException("Deserialization not supported");
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public AdapterDeserializer(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

