/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.state.deserializer;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.vality.adapter.common.model.Callback;
import dev.vality.adapter.common.state.deserializer.DeserializationException;
import dev.vality.adapter.common.state.deserializer.Deserializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

public class CallbackDeserializer
implements Deserializer<Callback> {
    private final ObjectMapper mapper;

    @Override
    public Callback read(byte[] data) {
        if (data == null) {
            return new Callback();
        }
        try {
            return (Callback)this.getMapper().readValue(data, Callback.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Callback read(String data) {
        throw new DeserializationException("Deserialization not supported");
    }

    public Callback read(HttpServletRequest request) {
        Map<String, String> stringMap = Optional.ofNullable(request.getParameterMap()).orElseGet(HashMap::new).entrySet().stream().collect(Collectors.toMap(k -> ((String)k.getKey()).trim(), v -> ((String[])v.getValue())[0]));
        return (Callback)this.mapper.convertValue(stringMap, Callback.class);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public CallbackDeserializer(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

