/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.state.serializer;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.vality.adapter.common.state.serializer.SerializationException;
import dev.vality.adapter.common.state.serializer.Serializer;
import java.io.IOException;
import java.util.Base64;

public abstract class StateSerializer<T>
implements Serializer<T> {
    protected final ObjectMapper mapper;

    @Override
    public byte[] writeByte(Object obj) {
        try {
            return this.mapper.writeValueAsBytes(obj);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public String writeString(Object obj) {
        try {
            return Base64.getEncoder().encodeToString(this.getMapper().writeValueAsBytes(obj));
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public StateSerializer(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

