/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.utils.cds.creators;

import com.github.javafaker.Faker;
import com.github.javafaker.Name;
import dev.vality.adapter.common.exception.CdsStorageExpDateException;
import dev.vality.adapter.common.utils.cds.model.CardDataProxyModel;
import dev.vality.cds.storage.CardData;
import dev.vality.damsel.domain.BankCard;
import java.util.Locale;

public class BankCardExtractor {
    private static final Name FAKER_NAME = new Faker(Locale.ENGLISH).name();
    private static final String NAME_REGEXP = "[^a-zA-Z +]";

    public static CardDataProxyModel initCardDataProxyModel(BankCard bankCard, CardData cardData) {
        String cardHolder = bankCard.isSetCardholderName() ? bankCard.getCardholderName() : (cardData.isSetCardholderName() ? cardData.getCardholderName() : (FAKER_NAME.firstName() + " " + FAKER_NAME.lastName()).replaceAll(NAME_REGEXP, "").toUpperCase());
        if (!bankCard.isSetExpDate() && !cardData.isSetExpDate()) {
            throw new CdsStorageExpDateException("Expiration date not found");
        }
        return CardDataProxyModel.builder().cardholderName(cardHolder).pan(cardData.getPan()).expMonth(bankCard.isSetExpDate() ? bankCard.getExpDate().getMonth() : cardData.getExpDate().getMonth()).expYear(bankCard.isSetExpDate() ? bankCard.getExpDate().getYear() : cardData.getExpDate().getYear()).build();
    }

    private BankCardExtractor() {
    }
}

