/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.utils.converter;

import dev.vality.adapter.common.utils.cds.model.CardDataProxyModel;
import dev.vality.cds.storage.CardData;
import dev.vality.cds.storage.ExpDate;
import dev.vality.damsel.domain.BankCard;
import dev.vality.damsel.domain.BankCardExpDate;
import java.util.Calendar;

public class BankCardUtils {
    private static final String DEFAULT_NUMBER_FORMAT = "%1$02d";
    public static final String DEFAULT_EXP_DATE_FORMAT = "%1$02d%2$02d";
    public static final String YYMM_EXP_DATE_FORMAT = "%1$02d%2$02d";
    public static final String MMYY_EXP_DATE_FORMAT = "%2$02d%1$02d";

    public static String getFullCardExpDate(CardDataProxyModel expDate) {
        return BankCardUtils.getFullCardExpDate(expDate.getExpYear(), expDate.getExpMonth());
    }

    public static String getFullCardExpDate(BankCardExpDate expDate) {
        return BankCardUtils.getFullCardExpDate(expDate.getYear(), expDate.getMonth());
    }

    public static String getFullCardExpDate(short year, byte month) {
        int correctYear = year < 100 ? year + 2000 : year;
        return String.format("%1$04d%2$02d%3$02d", correctYear, month, BankCardUtils.getDayOfMonth((short)year, month));
    }

    public static Integer getDayOfMonth(CardDataProxyModel cardData) {
        return BankCardUtils.getDayOfMonth(cardData.getExpYear(), cardData.getExpMonth());
    }

    public static Integer getDayOfMonth(CardData cardData) {
        ExpDate expDate = cardData.getExpDate();
        return BankCardUtils.getDayOfMonth(expDate.getYear(), expDate.getMonth());
    }

    public static Integer getDayOfMonth(BankCardExpDate expDate) {
        return BankCardUtils.getDayOfMonth(expDate.getYear(), expDate.getMonth());
    }

    public static Integer getDayOfMonth(short year, byte month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, -1);
        return calendar.getActualMaximum(5);
    }

    public static String getYearFromExpDate(CardDataProxyModel expDate) {
        return BankCardUtils.getBankCardFormattedYear(expDate.getExpYear());
    }

    public static String getYearFromExpDate(BankCardExpDate expDate) {
        return BankCardUtils.getBankCardFormattedYear(expDate.getYear());
    }

    public static String getMonthFromExpDate(CardDataProxyModel expDate) {
        return BankCardUtils.getBankCardFormattedMonth(expDate.getExpMonth());
    }

    public static String getMonthFromExpDate(BankCardExpDate expDate) {
        return BankCardUtils.getBankCardFormattedMonth(expDate.getMonth());
    }

    public static String getBankCardFormattedYear(Short year) {
        return String.format(DEFAULT_NUMBER_FORMAT, year % 100);
    }

    public static String getBankCardFormattedMonth(Byte month) {
        return String.format(DEFAULT_NUMBER_FORMAT, month);
    }

    public static String expDateToString(CardData cardData, BankCard bankCard) {
        if (cardData.isSetExpDate()) {
            return BankCardUtils.expDateToString(cardData.getExpDate());
        }
        return BankCardUtils.expDateToString(bankCard.getExpDate());
    }

    public static String expDateToString(CardDataProxyModel model) {
        return BankCardUtils.expDateToString(model.getExpYear(), model.getExpMonth(), "%1$02d%2$02d");
    }

    public static String expDateToString(CardDataProxyModel model, String expDateFormat) {
        return BankCardUtils.expDateToString(model.getExpYear(), model.getExpMonth(), expDateFormat);
    }

    public static String expDateToString(ExpDate expDate) {
        return BankCardUtils.expDateToString(expDate.getYear(), expDate.getMonth(), "%1$02d%2$02d");
    }

    public static String expDateToString(ExpDate expDate, String expDateFormat) {
        return BankCardUtils.expDateToString(expDate.getYear(), expDate.getMonth(), expDateFormat);
    }

    public static String expDateToString(BankCardExpDate expDate) {
        return BankCardUtils.expDateToString(expDate.getYear(), expDate.getMonth(), "%1$02d%2$02d");
    }

    public static String expDateToString(BankCardExpDate expDate, String expDateFormat) {
        return BankCardUtils.expDateToString(expDate.getYear(), expDate.getMonth(), expDateFormat);
    }

    public static String expDateToString(short year, byte month, String expDateFormat) {
        return String.format(expDateFormat, year % 100, month);
    }

    private BankCardUtils() {
    }
}

