/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.utils.damsel.creators;

import dev.vality.damsel.domain.BankCard;
import dev.vality.damsel.domain.BankCardExpDate;
import dev.vality.damsel.domain.Cash;
import dev.vality.damsel.domain.Category;
import dev.vality.damsel.domain.CategoryRef;
import dev.vality.damsel.domain.ClientInfo;
import dev.vality.damsel.domain.ContactInfo;
import dev.vality.damsel.domain.Currency;
import dev.vality.damsel.domain.CurrencyRef;
import dev.vality.damsel.domain.DisposablePaymentResource;
import dev.vality.damsel.domain.Failure;
import dev.vality.damsel.domain.Invoice;
import dev.vality.damsel.domain.InvoicePaymentCancelled;
import dev.vality.damsel.domain.InvoicePaymentCaptured;
import dev.vality.damsel.domain.InvoicePaymentProcessed;
import dev.vality.damsel.domain.InvoicePaymentRefunded;
import dev.vality.damsel.domain.LegacyBankCardPaymentSystem;
import dev.vality.damsel.domain.Payer;
import dev.vality.damsel.domain.PaymentResourcePayer;
import dev.vality.damsel.domain.PaymentTool;
import dev.vality.damsel.domain.Shop;
import dev.vality.damsel.domain.ShopDetails;
import dev.vality.damsel.domain.ShopLocation;
import dev.vality.damsel.domain.TargetInvoicePaymentStatus;
import dev.vality.damsel.domain.TransactionInfo;
import java.util.Map;

public class DomainPackageCreators {
    public static TargetInvoicePaymentStatus createTargetProcessed() {
        return TargetInvoicePaymentStatus.processed((InvoicePaymentProcessed)new InvoicePaymentProcessed());
    }

    public static TargetInvoicePaymentStatus createTargetCaptured() {
        return TargetInvoicePaymentStatus.captured((InvoicePaymentCaptured)new InvoicePaymentCaptured());
    }

    public static TargetInvoicePaymentStatus createTargetCancelled() {
        return TargetInvoicePaymentStatus.cancelled((InvoicePaymentCancelled)new InvoicePaymentCancelled());
    }

    public static TargetInvoicePaymentStatus createTargetRefunded() {
        return TargetInvoicePaymentStatus.refunded((InvoicePaymentRefunded)new InvoicePaymentRefunded());
    }

    public static dev.vality.damsel.proxy_provider.Cash createCash(Currency currency, Long amount) {
        return new dev.vality.damsel.proxy_provider.Cash(amount.longValue(), currency);
    }

    public static dev.vality.damsel.proxy_provider.Cash createCash(Long amount, String name, Integer numericCode, String symbolicCode, Integer exponent) {
        return new dev.vality.damsel.proxy_provider.Cash(amount.longValue(), DomainPackageCreators.createCurrency(name, numericCode, symbolicCode, exponent));
    }

    public static Cash createCash(CurrencyRef currency, Long amount) {
        return new Cash(amount.longValue(), currency);
    }

    @Deprecated
    public static BankCard createBankCardWithExpDate(String bin, String token, LegacyBankCardPaymentSystem bankCardPaymentSystem, String month, String year, String cardholderName) {
        return DomainPackageCreators.createBankCard(bin, token, bankCardPaymentSystem, DomainPackageCreators.createBankCardExpDate(month, year), cardholderName);
    }

    @Deprecated
    public static BankCard createBankCard(String bin, String token, LegacyBankCardPaymentSystem bankCardPaymentSystem, BankCardExpDate bankCardExpDate, String cardholderName) {
        return new BankCard().setBin(bin).setToken(token).setPaymentSystemDeprecated(bankCardPaymentSystem).setExpDate(bankCardExpDate).setCardholderName(cardholderName);
    }

    public static BankCard createBankCard(String month, String year, String cardholderName) {
        return new BankCard().setExpDate(DomainPackageCreators.createBankCardExpDate(month, year)).setCardholderName(cardholderName);
    }

    public static BankCardExpDate createBankCardExpDate(byte month, short year) {
        return new BankCardExpDate(month, year);
    }

    public static BankCardExpDate createBankCardExpDate(String month, String year) {
        return DomainPackageCreators.createBankCardExpDate(Byte.parseByte(month), Short.parseShort(year));
    }

    public static Shop createShop(CategoryRef categoryRef, ShopDetails shopDetails) {
        return new Shop().setCategory(categoryRef).setDetails(shopDetails);
    }

    public static Invoice createInvoice(String invoiceID, String createdAt, Cash cost) {
        return new Invoice().setId(invoiceID).setCreatedAt(createdAt).setCost(cost);
    }

    public static Currency createCurrency(String name, short numericCode, String symbolicCode, short exponent) {
        return new Currency(name, symbolicCode, numericCode, exponent);
    }

    public static Currency createCurrency(String name, Integer numericCode, String symbolicCode, Integer exponent) {
        return DomainPackageCreators.createCurrency(name, numericCode.shortValue(), symbolicCode, exponent.shortValue());
    }

    public static CurrencyRef createCurrencyRef(String symbolicCode) {
        return new CurrencyRef(symbolicCode);
    }

    public static PaymentTool createPaymentTool(BankCard bankCard) {
        return PaymentTool.bank_card((BankCard)bankCard);
    }

    public static DisposablePaymentResource createDisposablePaymentResource(ClientInfo clientInfo, String paymentSessionId, PaymentTool paymentTool) {
        return new DisposablePaymentResource(paymentTool).setClientInfo(clientInfo).setPaymentSessionId(paymentSessionId);
    }

    public static PaymentResourcePayer createPaymentResourcePayer(ContactInfo contactInfo, DisposablePaymentResource paymentResource) {
        return new PaymentResourcePayer(paymentResource, contactInfo);
    }

    public static Payer createPayer(PaymentResourcePayer paymentResourcePayer) {
        return Payer.payment_resource((PaymentResourcePayer)paymentResourcePayer);
    }

    public static ClientInfo createClientInfo(String fingerprint, String ipAddress) {
        return new ClientInfo().setFingerprint(fingerprint).setIpAddress(ipAddress);
    }

    public static ContactInfo createContactInfo(String email, String phoneNumber) {
        return new ContactInfo().setEmail(email).setPhoneNumber(phoneNumber);
    }

    public static ContactInfo createContactInfoWithEmail(String email) {
        return new ContactInfo().setEmail(email);
    }

    public static ContactInfo createContactInfoWithPhoneNumber(String phoneNumber) {
        return new ContactInfo().setPhoneNumber(phoneNumber);
    }

    public static ShopLocation createShopLocation(String url) {
        return ShopLocation.url((String)url);
    }

    public static ShopDetails createShopDetails(String name, String description) {
        return new ShopDetails(name).setDescription(description);
    }

    public static Category createCategory(String name, String description) {
        return new Category(name, description);
    }

    public static Failure createFailure(String code, String description) {
        return new Failure(code).setReason(description);
    }

    public static TransactionInfo createTransactionInfo(String paymentId, Map<String, String> extra, String timestamp) {
        return new TransactionInfo().setId(paymentId).setExtra(extra).setTimestamp(timestamp);
    }

    public static TransactionInfo createTransactionInfo(String paymentId, Map<String, String> extra) {
        return DomainPackageCreators.createTransactionInfo(paymentId, extra, null);
    }

    private DomainPackageCreators() {
    }
}

