/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.utils.encryption;

import dev.vality.adapter.common.utils.encryption.HmacEncryptionException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.springframework.util.MultiValueMap;

public final class HmacEncryption {
    public static String calculateHMacSha1(String data, String key) {
        return HmacEncryption.calculateHmac(data, key, HmacAlgorithms.HMAC_SHA_1.getName());
    }

    public static String calculateHMacSha256(String data, String key) {
        return HmacEncryption.calculateHmac(data, key, HmacAlgorithms.HMAC_SHA_256.getName());
    }

    public static String calculateHmac(String data, String hexEncodedKey, String algorithm) {
        try {
            byte[] decodedKey = Hex.decodeHex((char[])hexEncodedKey.toCharArray());
            return HmacEncryption.calculateHmac(data, decodedKey, algorithm);
        }
        catch (Exception ex) {
            throw new HmacEncryptionException(ex);
        }
    }

    public static String calculateHmac(String data, byte[] key, String algorithm) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(keySpec);
            byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
            byte[] resultBytes = mac.doFinal(dataBytes);
            return new String(new Hex().encode(resultBytes));
        }
        catch (Exception ex) {
            throw new HmacEncryptionException(ex);
        }
    }

    public static String prepareDataForHmac(String[] fields, MultiValueMap<String, String> params) {
        StringBuilder dataHmac = new StringBuilder();
        Arrays.asList(fields).forEach(HmacEncryption.fillDataHmac(params, dataHmac));
        return dataHmac.toString();
    }

    private static Consumer<String> fillDataHmac(MultiValueMap<String, String> params, StringBuilder dataHmac) {
        return field -> {
            if (HmacEncryption.hasFieldAndNotEmpty(params, field)) {
                dataHmac.append(((String)((List)params.get(field)).get(0)).length());
                dataHmac.append((String)((List)params.get(field)).get(0));
            } else {
                dataHmac.append("-");
            }
        };
    }

    private static boolean hasFieldAndNotEmpty(MultiValueMap<String, String> params, String field) {
        return params.get((Object)field) != null && !((List)params.get((Object)field)).isEmpty() && ((List)params.get((Object)field)).get(0) != null && !((String)((List)params.get((Object)field)).get(0)).isEmpty();
    }

    public static String sign(String[] fieldsForSign, MultiValueMap<String, String> params, String key, String algorithm) {
        String dataHmac = HmacEncryption.prepareDataForHmac(fieldsForSign, params);
        String sign = HmacEncryption.calculateHmac(dataHmac, key, algorithm);
        return sign.toUpperCase();
    }

    private HmacEncryption() {
    }
}

