/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.utils.generator;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class IpGenerator {
    private static final Logger log = LoggerFactory.getLogger(IpGenerator.class);
    public static final String DEFAULT_IP_ADDRESS = "127.0.0.1";

    public static String checkAndGenerate(String ip) {
        return IpGenerator.checkAndGenerate(ip, DEFAULT_IP_ADDRESS);
    }

    public static String checkAndGenerate(String ip, String defaultIpAddress) {
        try {
            InetAddress address = InetAddress.getByName(ip);
            if (StringUtils.isEmpty((Object)ip) || address instanceof Inet6Address) {
                return defaultIpAddress;
            }
        }
        catch (UnknownHostException e) {
            log.error("Error when convert ipAddress: {}", (Object)ip, (Object)e);
            return defaultIpAddress;
        }
        return ip;
    }

    private IpGenerator() {
    }
}

